/*
 * Decompiled with CFR 0.152.
 */
package net.luckperms.api;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.luckperms.api.actionlog.ActionLogger;
import net.luckperms.api.context.ContextManager;
import net.luckperms.api.event.EventBus;
import net.luckperms.api.messaging.MessagingService;
import net.luckperms.api.messenger.MessengerProvider;
import net.luckperms.api.metastacking.MetaStackFactory;
import net.luckperms.api.model.group.GroupManager;
import net.luckperms.api.model.user.UserManager;
import net.luckperms.api.node.NodeBuilderRegistry;
import net.luckperms.api.node.matcher.NodeMatcherFactory;
import net.luckperms.api.platform.Platform;
import net.luckperms.api.platform.PlayerAdapter;
import net.luckperms.api.platform.PluginMetadata;
import net.luckperms.api.query.QueryOptionsRegistry;
import net.luckperms.api.track.TrackManager;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.ApiStatus;

public interface LuckPerms {
    public @NonNull String getServerName();

    public @NonNull UserManager getUserManager();

    public @NonNull GroupManager getGroupManager();

    public @NonNull TrackManager getTrackManager();

    public <T> @NonNull PlayerAdapter<T> getPlayerAdapter(@NonNull Class<T> var1);

    public @NonNull Platform getPlatform();

    public @NonNull PluginMetadata getPluginMetadata();

    public @NonNull EventBus getEventBus();

    public @NonNull Optional<MessagingService> getMessagingService();

    public @NonNull ActionLogger getActionLogger();

    public @NonNull ContextManager getContextManager();

    public @NonNull MetaStackFactory getMetaStackFactory();

    public @NonNull CompletableFuture<Void> runUpdateTask();

    public void registerMessengerProvider(@NonNull MessengerProvider var1);

    @ApiStatus.Internal
    public @NonNull NodeBuilderRegistry getNodeBuilderRegistry();

    @ApiStatus.Internal
    public @NonNull QueryOptionsRegistry getQueryOptionsRegistry();

    @ApiStatus.Internal
    public @NonNull NodeMatcherFactory getNodeMatcherFactory();
}

