/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.verbose.event;

import com.google.gson.JsonObject;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import me.lucko.luckperms.common.util.StackTracePrinter;
import me.lucko.luckperms.common.util.gson.JArray;
import me.lucko.luckperms.common.util.gson.JObject;
import me.lucko.luckperms.common.verbose.VerboseCheckTarget;
import me.lucko.luckperms.common.verbose.event.CheckOrigin;
import me.lucko.luckperms.common.verbose.event.VerboseEventType;
import me.lucko.luckperms.common.verbose.expression.BooleanExpressionCompiler;
import net.luckperms.api.cacheddata.Result;
import net.luckperms.api.context.Context;
import net.luckperms.api.query.QueryMode;
import net.luckperms.api.query.QueryOptions;

public abstract class VerboseEvent
implements BooleanExpressionCompiler.VariableEvaluator {
    private final CheckOrigin origin;
    private final VerboseCheckTarget checkTarget;
    private final QueryOptions checkQueryOptions;
    private final long checkTime;
    private final Throwable checkTrace;
    private final String checkThread;

    protected VerboseEvent(CheckOrigin origin, VerboseCheckTarget checkTarget, QueryOptions checkQueryOptions, long checkTime, Throwable checkTrace, String checkThread) {
        this.origin = origin;
        this.checkTarget = checkTarget;
        this.checkQueryOptions = checkQueryOptions;
        this.checkTime = checkTime;
        this.checkTrace = checkTrace;
        this.checkThread = checkThread;
    }

    public CheckOrigin getOrigin() {
        return this.origin;
    }

    public VerboseCheckTarget getCheckTarget() {
        return this.checkTarget;
    }

    public abstract Result<?, ?> getResult();

    public QueryOptions getCheckQueryOptions() {
        return this.checkQueryOptions;
    }

    public long getCheckTime() {
        return this.checkTime;
    }

    public StackTraceElement[] getCheckTrace() {
        return this.checkTrace.getStackTrace();
    }

    public String getCheckThread() {
        return this.checkThread;
    }

    public abstract VerboseEventType getType();

    protected abstract void serializeTo(JObject var1);

    public JsonObject toJson(StackTracePrinter tracePrinter) {
        return new JObject().add("type", this.getType().toString()).add("origin", this.origin.name().toLowerCase(Locale.ROOT)).add("who", new JObject().add("identifier", this.checkTarget.describe()).add("type", this.checkTarget.getType()).add("name", this.checkTarget.getName()).consume(obj -> {
            UUID uuid = this.checkTarget.getId();
            if (uuid != null) {
                obj.add("uuid", uuid.toString());
            }
        })).add("queryMode", this.checkQueryOptions.mode().name().toLowerCase(Locale.ROOT)).consume(obj -> {
            if (this.checkQueryOptions.mode() == QueryMode.CONTEXTUAL) {
                obj.add("context", new JArray().consume(arr -> {
                    for (Context contextPair : Objects.requireNonNull(this.checkQueryOptions.context())) {
                        arr.add(new JObject().add("key", contextPair.getKey()).add("value", contextPair.getValue()));
                    }
                }));
            }
        }).add("time", this.checkTime).add("trace", new JArray().consume(arr -> {
            int overflow = tracePrinter.process(this.getCheckTrace(), StackTracePrinter.elementToString(arr::add));
            if (overflow != 0) {
                arr.add("... and " + overflow + " more");
            }
        })).add("thread", this.checkThread).consume(this::serializeTo).toJson();
    }
}

