/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.sender;

import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.context.manager.ContextManager;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.lib.adventure.text.Component;
import net.luckperms.api.context.ImmutableContextSet;
import net.luckperms.api.util.Tristate;

public interface Sender {
    public static final UUID CONSOLE_UUID = new UUID(0L, 0L);
    public static final String CONSOLE_NAME = "Console";

    public LuckPermsPlugin getPlugin();

    public String getName();

    default public String getNameWithLocation() {
        Set<String> servers;
        String name = this.getName();
        ContextManager<?, ?> contextManager = this.getPlugin().getContextManager();
        if (contextManager == null) {
            return name;
        }
        ImmutableContextSet staticContext = contextManager.getStaticContext();
        if (staticContext.isEmpty()) {
            return name;
        }
        String location = staticContext.size() == 1 ? staticContext.iterator().next().getValue() : ((servers = staticContext.getValues("server")).size() == 1 ? servers.iterator().next() : staticContext.toSet().stream().map(pair -> pair.getKey() + "=" + pair.getValue()).collect(Collectors.joining(";")));
        return name + "@" + location;
    }

    public UUID getUniqueId();

    public void sendMessage(Component var1);

    public Tristate getPermissionValue(String var1);

    public boolean hasPermission(String var1);

    default public boolean hasPermission(CommandPermission permission) {
        return this.hasPermission(permission.getPermission());
    }

    public void performCommand(String var1);

    public boolean isConsole();

    default public boolean isValid() {
        return true;
    }
}

