/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.node.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import me.lucko.luckperms.common.context.serializer.ContextSetJsonSerializer;
import me.lucko.luckperms.common.node.factory.NodeBuilders;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeBuilder;
import net.luckperms.api.node.metadata.types.InheritanceOriginMetadata;

public class NodeJsonSerializer {
    private NodeJsonSerializer() {
    }

    public static JsonObject serializeNode(Node node, boolean includeInheritanceOrigin) {
        InheritanceOriginMetadata origin;
        JsonObject attributes = new JsonObject();
        attributes.addProperty("type", node.getType().name().toLowerCase(Locale.ROOT));
        attributes.addProperty("key", node.getKey());
        attributes.addProperty("value", Boolean.valueOf(node.getValue()));
        Instant expiry = node.getExpiry();
        if (expiry != null) {
            attributes.addProperty("expiry", (Number)expiry.getEpochSecond());
        }
        if (!node.getContexts().isEmpty()) {
            attributes.add("context", (JsonElement)ContextSetJsonSerializer.serialize(node.getContexts()));
        }
        if (includeInheritanceOrigin && (origin = (InheritanceOriginMetadata)node.getMetadata(InheritanceOriginMetadata.KEY).orElse(null)) != null) {
            JsonObject metadata = new JsonObject();
            metadata.add("inheritanceOrigin", (JsonElement)NodeJsonSerializer.serializeInheritanceOrigin(origin));
            attributes.add("metadata", (JsonElement)metadata);
        }
        return attributes;
    }

    private static JsonObject serializeInheritanceOrigin(InheritanceOriginMetadata origin) {
        JsonObject obj = new JsonObject();
        obj.addProperty("type", origin.getOrigin().getType());
        obj.addProperty("name", origin.getOrigin().getName());
        return obj;
    }

    public static JsonArray serializeNodes(Collection<Node> nodes) {
        JsonArray arr = new JsonArray();
        for (Node node : nodes) {
            arr.add((JsonElement)NodeJsonSerializer.serializeNode(node, false));
        }
        return arr;
    }

    public static Node deserializeNode(JsonElement ent) {
        JsonObject attributes = ent.getAsJsonObject();
        String key = attributes.get("key").getAsString();
        if (key.isEmpty()) {
            return null;
        }
        NodeBuilder<?, ?> builder = NodeBuilders.determineMostApplicable(key);
        boolean value = attributes.get("value").getAsBoolean();
        builder.value(value);
        if (attributes.has("expiry")) {
            builder.expiry(attributes.get("expiry").getAsLong());
        }
        if (attributes.has("context")) {
            builder.context(ContextSetJsonSerializer.deserialize(attributes.get("context")));
        }
        return builder.build();
    }

    public static Set<Node> deserializeNodes(JsonArray arr) {
        HashSet<Node> nodes = new HashSet<Node>();
        for (JsonElement ent : arr) {
            Node node = NodeJsonSerializer.deserializeNode(ent);
            if (node == null) continue;
            nodes.add(node);
        }
        return nodes;
    }
}

