/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.model;

import java.util.Objects;
import me.lucko.luckperms.common.model.HolderType;
import net.luckperms.api.model.PermissionHolder;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class PermissionHolderIdentifier
implements PermissionHolder.Identifier {
    private final String type;
    private final String name;

    public PermissionHolderIdentifier(HolderType type, String name) {
        this.type = Objects.requireNonNull(type, "type") == HolderType.USER ? "user" : "group";
        this.name = Objects.requireNonNull(name, "name");
    }

    public PermissionHolderIdentifier(String type, String name) {
        this.type = Objects.requireNonNull(type, "type");
        this.name = Objects.requireNonNull(name, "name");
    }

    @Override
    public @NonNull String getType() {
        return this.type;
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PermissionHolder.Identifier)) {
            return false;
        }
        PermissionHolder.Identifier that = (PermissionHolder.Identifier)o;
        return this.type.equals(that.getType()) && this.name.equals(that.getName());
    }

    public int hashCode() {
        return Objects.hash(this.type, this.name);
    }

    public String toString() {
        return this.type + '/' + this.name;
    }
}

