/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.messaging.pluginmsg;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import net.luckperms.api.messenger.IncomingMessageConsumer;
import net.luckperms.api.messenger.Messenger;
import net.luckperms.api.messenger.message.OutgoingMessage;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class AbstractPluginMessageMessenger
implements Messenger {
    public static final String CHANNEL = "luckperms:update";
    private final IncomingMessageConsumer consumer;

    protected AbstractPluginMessageMessenger(IncomingMessageConsumer consumer) {
        this.consumer = consumer;
    }

    @Override
    public final void sendOutgoingMessage(@NonNull OutgoingMessage outgoingMessage) {
        ByteArrayDataOutput dataOutput = ByteStreams.newDataOutput();
        dataOutput.writeUTF(outgoingMessage.asEncodedString());
        byte[] buf = dataOutput.toByteArray();
        this.sendOutgoingMessage(buf);
    }

    protected abstract void sendOutgoingMessage(byte[] var1);

    protected boolean handleIncomingMessage(byte[] buf) {
        ByteArrayDataInput dataInput = ByteStreams.newDataInput((byte[])buf);
        String decodedString = dataInput.readUTF();
        return this.consumer.consumeIncomingMessageAsString(decodedString);
    }
}

