/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.locale;

import com.google.common.collect.Maps;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.actionlog.LoggedAction;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.node.factory.NodeCommandFactory;
import me.lucko.luckperms.common.plugin.AbstractLuckPermsPlugin;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.plugin.bootstrap.LuckPermsBootstrap;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.DurationFormatter;
import me.lucko.luckperms.lib.adventure.text.BuildableComponent;
import me.lucko.luckperms.lib.adventure.text.Component;
import me.lucko.luckperms.lib.adventure.text.ComponentBuilder;
import me.lucko.luckperms.lib.adventure.text.ComponentLike;
import me.lucko.luckperms.lib.adventure.text.JoinConfiguration;
import me.lucko.luckperms.lib.adventure.text.TextComponent;
import me.lucko.luckperms.lib.adventure.text.TranslatableComponent;
import me.lucko.luckperms.lib.adventure.text.event.ClickEvent;
import me.lucko.luckperms.lib.adventure.text.event.HoverEvent;
import me.lucko.luckperms.lib.adventure.text.event.HoverEventSource;
import me.lucko.luckperms.lib.adventure.text.format.NamedTextColor;
import me.lucko.luckperms.lib.adventure.text.format.Style;
import me.lucko.luckperms.lib.adventure.text.format.TextColor;
import me.lucko.luckperms.lib.adventure.text.format.TextDecoration;
import me.lucko.luckperms.lib.adventure.text.minimessage.MiniMessage;
import me.lucko.luckperms.lib.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.luckperms.api.context.Context;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.node.ChatMetaType;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.metadata.types.InheritanceOriginMetadata;
import net.luckperms.api.node.types.ChatMetaNode;
import net.luckperms.api.node.types.InheritanceNode;
import net.luckperms.api.node.types.MetaNode;
import net.luckperms.api.util.Tristate;

public interface Message {
    public static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd '@' HH:mm:ss").withZone(ZoneId.systemDefault());
    public static final TextComponent OPEN_BRACKET = Component.text((char)'(');
    public static final TextComponent CLOSE_BRACKET = Component.text((char)')');
    public static final TextComponent FULL_STOP = Component.text((char)'.');
    public static final Component PREFIX_COMPONENT = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)Component.text((char)'['))).append(((TextComponent.Builder)((TextComponent.Builder)Component.text().decoration(TextDecoration.BOLD, true)).append((Component)Component.text((char)'L', (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((char)'P', (TextColor)NamedTextColor.DARK_AQUA)))).append((Component)Component.text((char)']'))).build();
    public static final Args1<LuckPermsBootstrap> STARTUP_BANNER = bootstrap -> {
        BuildableComponent infoLine1 = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)AbstractLuckPermsPlugin.getPluginName(), (TextColor)NamedTextColor.DARK_GREEN))).append((Component)Component.space())).append((Component)Component.text((String)("v" + bootstrap.getVersion()), (TextColor)NamedTextColor.AQUA))).build();
        BuildableComponent infoLine2 = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_GRAY)).append((Component)Component.text((String)"Running on "))).append((Component)Component.text((String)bootstrap.getType().getFriendlyName()))).append((Component)Component.text((String)" - "))).append((Component)Component.text((String)bootstrap.getServerBrand()))).build();
        return Message.joinNewline(new ComponentLike[]{((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"       ", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)" __    ", (TextColor)NamedTextColor.DARK_AQUA))).build(), ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"  |    ", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)"|__)   ", (TextColor)NamedTextColor.DARK_AQUA))).append((Component)infoLine1)).build(), ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"  |___ ", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)"|      ", (TextColor)NamedTextColor.DARK_AQUA))).append((Component)infoLine2)).build(), Component.empty()});
    };
    public static final Args1<String> VIEW_AVAILABLE_COMMANDS_PROMPT = label -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.commandsystem.available-commands").color((TextColor)NamedTextColor.DARK_AQUA)).args((Component)Component.text((String)('/' + label + " help"), (TextColor)NamedTextColor.GREEN)).append((Component)FULL_STOP));
    public static final Args0 NO_PERMISSION_FOR_SUBCOMMANDS = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.commandsystem.no-permission-subcommands").color((TextColor)NamedTextColor.DARK_AQUA)).append((Component)FULL_STOP));
    public static final Args0 ALREADY_EXECUTING_COMMAND = () -> Message.prefixed((ComponentLike)Component.translatable().key("luckperms.commandsystem.already-executing-command").color((TextColor)NamedTextColor.GRAY));
    public static final Args2<String, String> FIRST_TIME_SETUP = (label, username) -> Message.joinNewline(new ComponentLike[]{Message.prefixed((ComponentLike)Component.translatable().key("luckperms.first-time.no-permissions-setup").color((TextColor)NamedTextColor.DARK_AQUA)), Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.first-time.use-console-to-give-access").color((TextColor)NamedTextColor.DARK_AQUA)).append((Component)FULL_STOP)), Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.first-time.console-command-prompt").color((TextColor)NamedTextColor.DARK_AQUA)).append((Component)Component.text((char)':'))), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append((Component)Component.space())).append((Component)Component.text((char)'>', (Style)Style.style((TextDecoration)TextDecoration.BOLD)))).append((Component)Component.space())).append((Component)Component.text((String)(label + " user " + username + " permission set luckperms.* true"), (TextColor)NamedTextColor.GREEN))).append((Component)Component.newline())), Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.first-time.next-step").color((TextColor)NamedTextColor.DARK_AQUA)).append((Component)FULL_STOP)), Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.first-time.wiki-prompt").color((TextColor)NamedTextColor.DARK_AQUA)).args(((TextComponent.Builder)Component.text().content("https://luckperms.net/wiki/Usage").color((TextColor)NamedTextColor.GRAY)).clickEvent(ClickEvent.openUrl((String)"https://luckperms.net/wiki/Usage"))))});
    public static final Args0 LOADING_DATABASE_ERROR = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.login.loading-database-error").color((TextColor)NamedTextColor.RED)).append((Component)FULL_STOP)).append((Component)Component.space())).append((Component)Component.translatable((String)"luckperms.login.try-again"))).append((Component)FULL_STOP)).append((Component)Component.space())).append((Component)Component.translatable((String)"luckperms.login.server-admin-check-console-errors"))).append((Component)FULL_STOP));
    public static final Args0 LOADING_STATE_ERROR = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.login.data-not-loaded-at-pre").color((TextColor)NamedTextColor.RED)).append((Component)Component.text((String)" - "))).append((Component)Component.translatable((String)"luckperms.login.unable-to-continue"))).append((Component)FULL_STOP)).append((Component)Component.space())).append((Component)Component.translatable((String)"luckperms.login.try-again"))).append((Component)FULL_STOP)).append((Component)Component.space())).append((Component)Component.translatable((String)"luckperms.login.server-admin-check-console-errors"))).append((Component)FULL_STOP));
    public static final Args0 LOADING_STATE_ERROR_CB_OFFLINE_MODE = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.login.data-not-loaded-at-pre").color((TextColor)NamedTextColor.RED)).append((Component)Component.text((String)" - "))).append((Component)Component.translatable((String)"luckperms.login.craftbukkit-offline-mode-error"))).append((Component)FULL_STOP)).append((Component)Component.space())).append((Component)Component.translatable((String)"luckperms.login.server-admin-check-console-info"))).append((Component)FULL_STOP));
    public static final Args0 LOADING_SETUP_ERROR = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.login.unexpected-error").color((TextColor)NamedTextColor.RED)).append((Component)FULL_STOP)).append((Component)Component.space())).append((Component)Component.translatable((String)"luckperms.login.try-again"))).append((Component)FULL_STOP));
    public static final Args0 OP_DISABLED = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.opsystem.disabled").color((TextColor)NamedTextColor.AQUA)).append((Component)FULL_STOP));
    public static final Args0 OP_DISABLED_SPONGE = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.opsystem.sponge-warning").color((TextColor)NamedTextColor.DARK_GREEN)).append((Component)FULL_STOP));
    public static final Args1<LoggedAction> LOG = action -> Message.joinNewline(new ComponentLike[]{Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.translatable((String)"luckperms.logs.actionlog-prefix", (TextColor)NamedTextColor.DARK_AQUA))).append((Component)Component.space())).append((Component)Component.text((char)'>', (TextColor)NamedTextColor.DARK_AQUA, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.space())).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_GRAY)).append((Component)OPEN_BRACKET)).append((Component)Component.text((String)action.getSourceFriendlyString(), (TextColor)NamedTextColor.YELLOW))).append((Component)CLOSE_BRACKET))).append((Component)Component.space())).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_GRAY)).append((Component)Component.text((char)'['))).append((Component)Component.text((char)LoggedAction.getTypeCharacter(action.getTarget().getType()), (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((char)']')))).append((Component)Component.space())).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_GRAY)).append((Component)OPEN_BRACKET)).append((Component)Component.text((String)action.getTargetFriendlyString(), (TextColor)NamedTextColor.AQUA))).append((Component)CLOSE_BRACKET))), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.translatable((String)"luckperms.logs.actionlog-prefix", (TextColor)NamedTextColor.DARK_AQUA))).append((Component)Component.space())).append((Component)Component.text((char)'>', (TextColor)NamedTextColor.DARK_AQUA, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.space())).append((Component)Component.text((String)action.getDescription(), (TextColor)NamedTextColor.WHITE)))});
    public static final Args3<String, String, Tristate> VERBOSE_LOG_PERMISSION = (target, permission, result) -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.translatable((String)"luckperms.logs.verbose-prefix", (TextColor)NamedTextColor.DARK_AQUA))).append((Component)Component.space())).append((Component)Component.text((char)'>', (TextColor)NamedTextColor.DARK_AQUA, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.space())).append((Component)Component.text((String)target, (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)" - ", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)permission, (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)" - ", (TextColor)NamedTextColor.GRAY))).append(Message.formatTristate(result)));
    public static final Args3<String, String, String> VERBOSE_LOG_META = (target, metaKey, result) -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.translatable((String)"luckperms.logs.verbose-prefix", (TextColor)NamedTextColor.DARK_AQUA))).append((Component)Component.space())).append((Component)Component.text((char)'>', (TextColor)NamedTextColor.DARK_AQUA, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.space())).append((Component)Component.text((String)target, (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)" - ", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)"meta: ", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)metaKey, (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)" - ", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)result, (TextColor)NamedTextColor.GRAY)));
    public static final Args1<String> VERBOSE_LOG_HOVER_TYPE = type -> ((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.logs.verbose.hover.type-key").color((TextColor)NamedTextColor.GREEN)).append((Component)Component.text((String)": "))).append((Component)Component.text((String)type, (TextColor)NamedTextColor.DARK_GREEN))).build();
    public static final Args1<String> VERBOSE_LOG_HOVER_ORIGIN = origin -> ((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.logs.verbose.hover.origin-key").color((TextColor)NamedTextColor.AQUA)).append((Component)Component.text((String)": "))).append((Component)Component.text((String)origin, (TextColor)NamedTextColor.DARK_GREEN))).build();
    public static final Args1<Node> VERBOSE_LOG_HOVER_CAUSE = causeNode -> ((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.logs.verbose.hover.cause-key").color((TextColor)NamedTextColor.AQUA)).append((Component)Component.text((String)": "))).apply(builder -> {
        String origin = causeNode.getMetadata(InheritanceOriginMetadata.KEY).map(o -> o.getOrigin().getName()).orElse("?");
        builder.append((ComponentBuilder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.permission.check.info.directly").color((TextColor)NamedTextColor.GRAY)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).content(origin), Component.text((String)causeNode.getKey(), (TextColor)NamedTextColor.AQUA), Message.formatBoolean(causeNode.getValue()), Message.formatContextSet(causeNode.getContexts())}));
    })).build();
    public static final Args1<MetaNode> VERBOSE_LOG_HOVER_CAUSE_META = causeNode -> ((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.logs.verbose.hover.cause-key").color((TextColor)NamedTextColor.AQUA)).append((Component)Component.text((String)": "))).apply(builder -> {
        String origin = causeNode.getMetadata(InheritanceOriginMetadata.KEY).map(o -> o.getOrigin().getName()).orElse("?");
        builder.append((ComponentBuilder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.permission.check.info.directly").color((TextColor)NamedTextColor.GRAY)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).content(origin), Component.text((String)causeNode.getMetaKey(), (TextColor)NamedTextColor.AQUA), Message.formatColoredValue(causeNode.getMetaValue()), Message.formatContextSet(causeNode.getContexts())}));
    })).build();
    public static final Args1<ContextSet> VERBOSE_LOG_HOVER_CONTEXT = set -> ((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.logs.verbose.hover.context-key").color((TextColor)NamedTextColor.AQUA)).append((Component)Component.text((String)": "))).append(Message.formatContextSet(set))).build();
    public static final Args1<String> VERBOSE_LOG_HOVER_THREAD = threadName -> ((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.logs.verbose.hover.thread-key").color((TextColor)NamedTextColor.AQUA)).append((Component)Component.text((String)": "))).append((Component)Component.text((String)threadName, (TextColor)NamedTextColor.WHITE))).build();
    public static final Args0 VERBOSE_LOG_HOVER_TRACE_TITLE = () -> ((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.logs.verbose.hover.trace-key").color((TextColor)NamedTextColor.AQUA)).append((Component)Component.text((char)':'))).build();
    public static final Args1<String> VERBOSE_LOG_HOVER_TRACE_CONTENT = content -> Component.text((String)content, (TextColor)NamedTextColor.GRAY);
    public static final Args1<Integer> VERBOSE_LOG_HOVER_TRACE_OVERFLOW = overflow -> ((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.WHITE)).content("... ").append((ComponentBuilder)Component.translatable().key("luckperms.logs.verbose.hover.overflow").args((Component)Component.text((int)overflow)))).build();
    public static final Args1<String> VERBOSE_LOG_HOVER_PROCESSOR = processor -> ((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.logs.verbose.hover.processor-key").color((TextColor)NamedTextColor.AQUA)).append((Component)Component.text((String)": "))).append((Component)Component.text((String)processor, (TextColor)NamedTextColor.DARK_GREEN))).build();
    public static final Args1<String> EXPORT_LOG = msg -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.translatable((String)"luckperms.logs.export-prefix", (TextColor)NamedTextColor.DARK_AQUA))).append((Component)Component.space())).append((Component)Component.text((char)'>', (TextColor)NamedTextColor.DARK_AQUA, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.space())).append((Component)Component.text((String)msg, (TextColor)NamedTextColor.WHITE)));
    public static final Args1<String> EXPORT_LOG_PROGRESS = msg -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.translatable((String)"luckperms.logs.export-prefix", (TextColor)NamedTextColor.DARK_AQUA))).append((Component)Component.space())).append((Component)Component.text((char)'>', (TextColor)NamedTextColor.DARK_AQUA, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.space())).append((Component)Component.text((String)msg, (TextColor)NamedTextColor.GRAY)));
    public static final Args0 COMMAND_NOT_RECOGNISED = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.commandsystem.command-not-recognised").color((TextColor)NamedTextColor.RED)).append((Component)FULL_STOP));
    public static final Args0 COMMAND_NO_PERMISSION = () -> Message.prefixed((ComponentLike)Component.translatable().key("luckperms.commandsystem.no-permission").color((TextColor)NamedTextColor.RED));
    public static final Args2<String, String> MAIN_COMMAND_USAGE_HEADER = (name, usage) -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append((Component)Component.text((String)name))).append((Component)Component.space())).append((Component)Component.translatable((String)"luckperms.commandsystem.usage.sub-commands-header"))).append((Component)Component.text((String)": "))).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)OPEN_BRACKET)).append((Component)Component.text((String)usage))).append((Component)Component.text((String)" ..."))).append((Component)CLOSE_BRACKET)));
    public static final Args2<String, Component> COMMAND_USAGE_DETAILED_HEADER = (name, usage) -> Message.joinNewline(new ComponentLike[]{Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.translatable((String)"luckperms.commandsystem.usage.usage-header", (TextColor)NamedTextColor.DARK_AQUA, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)" - ", (TextColor)NamedTextColor.DARK_AQUA))).append((Component)Component.text((String)name, (TextColor)NamedTextColor.AQUA))), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((char)'>', (TextColor)NamedTextColor.AQUA))).append((Component)Component.space())).append(((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append(usage)))});
    public static final Args0 COMMAND_USAGE_DETAILED_ARGS_HEADER = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.commandsystem.usage.arguments-header").color((TextColor)NamedTextColor.DARK_AQUA)).append((Component)Component.text((char)':')));
    public static final Args2<Component, Component> COMMAND_USAGE_DETAILED_ARG = (arg, usage) -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((char)'-', (TextColor)NamedTextColor.AQUA))).append((Component)Component.space())).append(arg)).append((Component)Component.text((String)" -> ", (TextColor)NamedTextColor.DARK_AQUA))).append(((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append(usage)));
    public static final Args1<String> REQUIRED_ARGUMENT = name -> ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_GRAY)).append((Component)Component.text((char)'<'))).append((Component)Component.text((String)name, (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((char)'>'))).build();
    public static final Args1<String> OPTIONAL_ARGUMENT = name -> ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_GRAY)).append((Component)Component.text((char)'['))).append((Component)Component.text((String)name, (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((char)']'))).build();
    public static final Args1<String> USER_NOT_ONLINE = id -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.misc.loading.error.user-not-online").color((TextColor)NamedTextColor.GREEN)).args((Component)Component.text((String)id, (TextColor)NamedTextColor.AQUA)).append((Component)FULL_STOP));
    public static final Args1<String> USER_NOT_FOUND = id -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.misc.loading.error.user-not-found").color((TextColor)NamedTextColor.RED)).args((Component)Component.text((String)id, (TextColor)NamedTextColor.DARK_RED)).append((Component)FULL_STOP));
    public static final Args1<String> GROUP_NOT_FOUND = id -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.misc.loading.error.group-not-found").color((TextColor)NamedTextColor.RED)).args((Component)Component.text((String)id, (TextColor)NamedTextColor.DARK_RED)).append((Component)FULL_STOP));
    public static final Args1<String> TRACK_NOT_FOUND = id -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.misc.loading.error.track-not-found").color((TextColor)NamedTextColor.RED)).args((Component)Component.text((String)id, (TextColor)NamedTextColor.DARK_RED)).append((Component)FULL_STOP));
    public static final Args1<User> USER_SAVE_ERROR = user -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.misc.loading.error.user-save-error").color((TextColor)NamedTextColor.RED)).args(((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_RED)).append(user.getFormattedDisplayName())).append((Component)FULL_STOP));
    public static final Args1<Group> GROUP_SAVE_ERROR = group -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.misc.loading.error.group-save-error").color((TextColor)NamedTextColor.RED)).args(((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_RED)).append(group.getFormattedDisplayName())).append((Component)FULL_STOP));
    public static final Args1<String> TRACK_SAVE_ERROR = id -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.misc.loading.error.track-save-error").color((TextColor)NamedTextColor.RED)).args((Component)Component.text((String)id, (TextColor)NamedTextColor.DARK_RED)).append((Component)FULL_STOP));
    public static final Args1<String> USER_INVALID_ENTRY = invalid -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.misc.loading.error.user-invalid").color((TextColor)NamedTextColor.RED)).args((Component)Component.text((String)invalid, (TextColor)NamedTextColor.DARK_RED)).append((Component)FULL_STOP));
    public static final Args1<String> GROUP_INVALID_ENTRY = invalid -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.misc.loading.error.group-invalid").color((TextColor)NamedTextColor.RED)).args((Component)Component.text((String)invalid, (TextColor)NamedTextColor.DARK_RED)).append((Component)FULL_STOP));
    public static final Args1<String> TRACK_INVALID_ENTRY = invalid -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.misc.loading.error.track-invalid").color((TextColor)NamedTextColor.RED)).args((Component)Component.text((String)invalid, (TextColor)NamedTextColor.DARK_RED)).append((Component)FULL_STOP));
    public static final Args2<String, String> VERBOSE_INVALID_FILTER = (invalid, error) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.verbose.invalid-filter").color((TextColor)NamedTextColor.RED)).args((Component)Component.text((String)invalid, (TextColor)NamedTextColor.DARK_RED)).append((Component)FULL_STOP)).append((Component)Component.space())).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)OPEN_BRACKET)).append((Component)Component.text((String)error))).append((Component)CLOSE_BRACKET)));
    public static final Args0 VERBOSE_ON = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.verbose.enabled").color((TextColor)NamedTextColor.AQUA)).args(new ComponentLike[]{Component.translatable((String)"luckperms.command.verbose.enabled-term", (TextColor)NamedTextColor.GREEN), Component.translatable((String)"luckperms.command.verbose.query-any", (TextColor)NamedTextColor.GREEN)}).append((Component)FULL_STOP));
    public static final Args1<String> VERBOSE_ON_QUERY = query -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.verbose.enabled").color((TextColor)NamedTextColor.AQUA)).args(new ComponentLike[]{Component.translatable((String)"luckperms.command.verbose.enabled-term", (TextColor)NamedTextColor.GREEN), Component.text((String)query, (TextColor)NamedTextColor.GREEN)}).append((Component)FULL_STOP));
    public static final Args2<String, String> VERBOSE_ON_COMMAND = (user, command) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.verbose.command-exec").color((TextColor)NamedTextColor.AQUA)).args(new ComponentLike[]{Component.text((String)user, (TextColor)NamedTextColor.GREEN), Component.text((String)command, (TextColor)NamedTextColor.GREEN)}).append((Component)FULL_STOP));
    public static final Args0 VERBOSE_OFF = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.verbose.off").color((TextColor)NamedTextColor.AQUA)).args((Component)Component.translatable((String)"luckperms.command.verbose.disabled-term", (TextColor)NamedTextColor.RED)).append((Component)FULL_STOP));
    public static final Args0 VERBOSE_OFF_COMMAND = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.verbose.command-exec-complete").color((TextColor)NamedTextColor.AQUA)).append((Component)FULL_STOP));
    public static final Args0 VERBOSE_OFF_COMMAND_NO_CHECKS = () -> Message.joinNewline(new ComponentLike[]{Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.verbose.command.no-checks").color((TextColor)NamedTextColor.AQUA)).append((Component)FULL_STOP)), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)Component.translatable((String)"luckperms.command.verbose.command.possibly-async"))).append((Component)FULL_STOP)).append((Component)Component.space())).append((Component)Component.translatable((String)"luckperms.command.verbose.command.try-again-manually"))).append((Component)FULL_STOP))});
    public static final Args0 VERBOSE_RECORDING_ON = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.verbose.enabled-recording").color((TextColor)NamedTextColor.AQUA)).args(new ComponentLike[]{Component.translatable((String)"luckperms.command.verbose.enabled-term", (TextColor)NamedTextColor.GREEN), Component.translatable((String)"luckperms.command.verbose.query-any", (TextColor)NamedTextColor.GREEN)}).append((Component)FULL_STOP));
    public static final Args1<String> VERBOSE_RECORDING_ON_QUERY = query -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.verbose.enabled-recording").color((TextColor)NamedTextColor.AQUA)).args(new ComponentLike[]{Component.translatable((String)"luckperms.command.verbose.enabled-term", (TextColor)NamedTextColor.GREEN), Component.text((String)query, (TextColor)NamedTextColor.GREEN)}).append((Component)FULL_STOP));
    public static final Args0 VERBOSE_UPLOAD_START = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.verbose.uploading").color((TextColor)NamedTextColor.AQUA)).args((Component)Component.translatable((String)"luckperms.command.verbose.disabled-term", (TextColor)NamedTextColor.RED)));
    public static final Args1<String> VERBOSE_RESULTS_URL = url -> Message.joinNewline(new ComponentLike[]{Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.verbose.url").color((TextColor)NamedTextColor.GREEN)).append((Component)Component.text((char)':'))), ((TextComponent.Builder)Component.text().content(url).color((TextColor)NamedTextColor.AQUA)).clickEvent(ClickEvent.openUrl((String)url))});
    public static final Args0 TREE_UPLOAD_START = () -> Message.prefixed((ComponentLike)Component.translatable().key("luckperms.command.tree.start").color((TextColor)NamedTextColor.AQUA));
    public static final Args0 TREE_EMPTY = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.tree.empty").color((TextColor)NamedTextColor.RED)).append((Component)FULL_STOP));
    public static final Args1<String> TREE_URL = url -> Message.joinNewline(new ComponentLike[]{Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.tree.url").color((TextColor)NamedTextColor.GREEN)).append((Component)Component.text((char)':'))), ((TextComponent.Builder)Component.text().content(url).color((TextColor)NamedTextColor.AQUA)).clickEvent(ClickEvent.openUrl((String)url))});
    public static final Args2<Integer, String> GENERIC_HTTP_REQUEST_FAILURE = (code, message) -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.RED)).append((Component)Component.translatable((String)"luckperms.command.misc.webapp-unable-to-communicate"))).append((Component)FULL_STOP)).append((Component)Component.space())).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)OPEN_BRACKET)).append((Component)Component.translatable((String)"luckperms.command.misc.response-code-key"))).append((Component)Component.space())).append((Component)Component.text((int)code))).append((Component)Component.text((String)", "))).append((Component)Component.translatable((String)"luckperms.command.misc.error-message-key"))).append((Component)Component.text((String)"='"))).append((Component)Component.text((String)message))).append((Component)Component.text((String)"'"))).append((Component)CLOSE_BRACKET)));
    public static final Args0 GENERIC_HTTP_UNKNOWN_FAILURE = () -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.RED)).append((Component)Component.translatable((String)"luckperms.command.misc.webapp-unable-to-communicate"))).append((Component)FULL_STOP)).append((Component)Component.space())).append((Component)Component.translatable((String)"luckperms.command.misc.check-console-for-errors"))).append((Component)FULL_STOP));
    public static final Args1<String> SEARCH_SEARCHING = searchQuery -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.search.searching.permission").color((TextColor)NamedTextColor.GREEN)).args((Component)Component.text((String)("permissions " + searchQuery), (TextColor)NamedTextColor.AQUA)).append((Component)Component.text((String)"...")));
    public static final Args1<String> SEARCH_SEARCHING_MEMBERS = group -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.search.searching.inherit").color((TextColor)NamedTextColor.GREEN)).args((Component)Component.text((String)group, (TextColor)NamedTextColor.AQUA)).append((Component)Component.text((String)"...")));
    public static final Args0 SEARCH_RESULT_GROUP_DEFAULT = () -> Message.prefixed((ComponentLike)Component.translatable().key("luckperms.command.search.result.default-notice").color((TextColor)NamedTextColor.GRAY));
    public static final Args3<Integer, Integer, Integer> SEARCH_RESULT = (entries, users, groups) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.search.result").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{Component.text((int)entries, (TextColor)NamedTextColor.AQUA), Component.text((int)users, (TextColor)NamedTextColor.AQUA), Component.text((int)groups, (TextColor)NamedTextColor.AQUA)}).append((Component)FULL_STOP));
    public static final Args3<Integer, Integer, Integer> SEARCH_SHOWING_USERS = (page, totalPages, totalEntries) -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append((Component)Component.translatable((String)"luckperms.command.search.showing-users"))).append((Component)Component.text((char)':'))).append((Component)Component.text((String)"    "))).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)OPEN_BRACKET)).append((ComponentBuilder)Component.translatable().key("luckperms.command.misc.page").args(new ComponentLike[]{Component.text((int)page, (TextColor)NamedTextColor.WHITE), Component.text((int)totalPages, (TextColor)NamedTextColor.WHITE)}))).append((Component)Component.text((String)" - "))).append((ComponentBuilder)Component.translatable().key("luckperms.command.misc.page-entries").args((Component)Component.text((int)totalEntries, (TextColor)NamedTextColor.WHITE)))).append((Component)CLOSE_BRACKET)));
    public static final Args3<Integer, Integer, Integer> SEARCH_SHOWING_GROUPS = (page, totalPages, totalEntries) -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append((Component)Component.translatable((String)"luckperms.command.search.showing-groups"))).append((Component)Component.text((char)':'))).append((Component)Component.text((String)"    "))).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)OPEN_BRACKET)).append((ComponentBuilder)Component.translatable().key("luckperms.command.misc.page").args(new ComponentLike[]{Component.text((int)page, (TextColor)NamedTextColor.WHITE), Component.text((int)totalPages, (TextColor)NamedTextColor.WHITE)}))).append((Component)Component.text((String)" - "))).append((ComponentBuilder)Component.translatable().key("luckperms.command.misc.page-entries").args((Component)Component.text((int)totalEntries, (TextColor)NamedTextColor.WHITE)))).append((Component)CLOSE_BRACKET)));
    public static final Args6<Boolean, Node, String, HolderType, String, LuckPermsPlugin> SEARCH_NODE_ENTRY = (showNode, node, holder, holderType, label, plugin) -> ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((char)'>', (TextColor)NamedTextColor.DARK_AQUA))).append((Component)Component.space())).append((Component)Component.text((String)holder, (TextColor)NamedTextColor.AQUA))).apply(builder -> {
        if (showNode.booleanValue()) {
            builder.append((Component)Component.text((String)" - ", (TextColor)NamedTextColor.GRAY));
            builder.append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)OPEN_BRACKET)).append((Component)Component.text((String)node.getKey()))).append((Component)CLOSE_BRACKET));
        }
    })).append((Component)Component.text((String)" - ", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((boolean)node.getValue(), (TextColor)(node.getValue() ? NamedTextColor.GREEN : NamedTextColor.RED)))).apply(builder -> {
        if (node.hasExpiry()) {
            builder.append((Component)Component.space());
            builder.append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_GRAY)).append((Component)OPEN_BRACKET)).append(((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.info.expires-in").color((TextColor)NamedTextColor.GRAY)).append((Component)Component.space())).append(DurationFormatter.LONG.format(node.getExpiryDuration())))).append((Component)CLOSE_BRACKET));
        }
    })).append((Component)Component.space())).append(Message.formatContextSetBracketed(node.getContexts(), (Component)Component.empty()))).apply(builder -> {
        boolean explicitGlobalContext = !plugin.getConfiguration().getContextsFile().getDefaultContexts().isEmpty();
        Component hover = Message.joinNewline(new ComponentLike[]{((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((char)'>', (TextColor)NamedTextColor.DARK_AQUA))).append((Component)Component.space())).append((Component)Component.text((String)node.getKey(), (TextColor)(node.getValue() ? NamedTextColor.GREEN : NamedTextColor.RED))), Component.text(), ((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.permission.info.click-to-remove").color((TextColor)NamedTextColor.GRAY)).args((Component)Component.text((String)holder))});
        String command = "/" + label + " " + NodeCommandFactory.undoCommand(node, holder, holderType, explicitGlobalContext);
        builder.hoverEvent((HoverEventSource)HoverEvent.showText((Component)hover));
        builder.clickEvent(ClickEvent.suggestCommand((String)command));
    })).build();
    public static final Args5<InheritanceNode, String, HolderType, String, LuckPermsPlugin> SEARCH_INHERITS_NODE_ENTRY = (node, holder, holderType, label, plugin) -> ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((char)'>', (TextColor)NamedTextColor.DARK_AQUA))).append((Component)Component.space())).append((Component)Component.text((String)holder, (TextColor)NamedTextColor.AQUA))).apply(builder -> {
        if (node.hasExpiry()) {
            builder.append((Component)Component.space());
            builder.append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_GRAY)).append((Component)OPEN_BRACKET)).append(((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.info.expires-in").color((TextColor)NamedTextColor.GRAY)).append((Component)Component.space())).append(DurationFormatter.LONG.format(node.getExpiryDuration())))).append((Component)CLOSE_BRACKET));
        }
    })).append((Component)Component.space())).append(Message.formatContextSetBracketed(node.getContexts(), (Component)Component.empty()))).apply(builder -> {
        boolean explicitGlobalContext = !plugin.getConfiguration().getContextsFile().getDefaultContexts().isEmpty();
        Component hover = Message.joinNewline(new ComponentLike[]{((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((char)'>', (TextColor)NamedTextColor.DARK_AQUA))).append((Component)Component.space())).append((Component)Component.text((String)node.getKey(), (TextColor)(node.getValue() ? NamedTextColor.GREEN : NamedTextColor.RED))), Component.text(), ((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.parent.info.click-to-remove").color((TextColor)NamedTextColor.GRAY)).args((Component)Component.text((String)holder))});
        String command = "/" + label + " " + NodeCommandFactory.undoCommand(node, holder, holderType, explicitGlobalContext);
        builder.hoverEvent((HoverEventSource)HoverEvent.showText((Component)hover));
        builder.clickEvent(ClickEvent.suggestCommand((String)command));
    })).build();
    public static final Args2<String, String> APPLY_EDITS_SESSION_UNKNOWN = (code, label) -> Message.joinNewline(new ComponentLike[]{Message.prefixed((ComponentLike)Component.translatable().key("luckperms.command.editor.apply-edits.unknown-session").color((TextColor)NamedTextColor.DARK_RED)), Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.editor.apply-edits.right-server-question").color((TextColor)NamedTextColor.RED)).args((Component)Component.text((String)("/" + label + " applyedits")))), Message.prefixed((ComponentLike)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.editor.apply-edits.bypass-warning").color((TextColor)NamedTextColor.RED)).append((Component)Component.text((String)": "))).append((Component)Component.text((String)("/" + label + " applyedits " + code + " --force"), (TextColor)NamedTextColor.DARK_RED)))});
    public static final Args2<String, String> APPLY_EDITS_SESSION_APPLIED_ALREADY = (code, label) -> Message.joinNewline(new ComponentLike[]{Message.prefixed((ComponentLike)Component.translatable().key("luckperms.command.editor.apply-edits.already-applied").color((TextColor)NamedTextColor.DARK_RED)), Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.editor.apply-edits.how-to-avoid-conflicts").color((TextColor)NamedTextColor.RED)).append((Component)FULL_STOP)), Message.prefixed((ComponentLike)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.editor.apply-edits.bypass-warning").color((TextColor)NamedTextColor.RED)).append((Component)Component.text((String)": "))).append((Component)Component.text((String)("/" + label + " applyedits " + code + " --force"))))});
    public static final Args1<String> APPLY_EDITS_INVALID_CODE = code -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.RED)).append((Component)Component.translatable((String)"luckperms.command.misc.invalid-code"))).append((Component)FULL_STOP)).append((Component)Component.space())).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)OPEN_BRACKET)).append((Component)Component.text((String)code))).append((Component)CLOSE_BRACKET)));
    public static final Args1<String> APPLY_EDITS_UNABLE_TO_READ = invalid -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.editor.apply-edits.unable-to-read").color((TextColor)NamedTextColor.RED)).append((Component)FULL_STOP)).append((Component)Component.space())).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)OPEN_BRACKET)).append((Component)Component.text((String)invalid))).append((Component)CLOSE_BRACKET)));
    public static final Args1<String> APPLY_EDITS_UNKNOWN_TYPE = invalid -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.editor.apply-edits.unknown-type").color((TextColor)NamedTextColor.RED)).append((Component)FULL_STOP)).append((Component)Component.space())).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)OPEN_BRACKET)).append((Component)Component.text((String)invalid))).append((Component)CLOSE_BRACKET)));
    public static final Args1<String> APPLY_EDITS_TARGET_USER_NOT_UUID = target -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.misc.loading.error.user-not-uuid").color((TextColor)NamedTextColor.RED)).args((Component)Component.text((String)target, (TextColor)NamedTextColor.DARK_RED)).append((Component)FULL_STOP));
    public static final Args1<String> APPLY_EDITS_TARGET_USER_UNABLE_TO_LOAD = target -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.misc.loading.error.user-specific").color((TextColor)NamedTextColor.RED)).args((Component)Component.text((String)target, (TextColor)NamedTextColor.DARK_RED)).append((Component)FULL_STOP));
    public static final Args0 APPLY_EDITS_TARGET_NO_CHANGES_PRESENT = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.editor.apply-edits.no-changes").color((TextColor)NamedTextColor.GREEN)).append((Component)FULL_STOP));
    public static final Args2<String, Component> APPLY_EDITS_SUCCESS = (type, name) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.editor.apply-edits.success").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{Component.text((String)type), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(name)}).append((Component)FULL_STOP));
    public static final Args2<Integer, Integer> APPLY_EDITS_SUCCESS_SUMMARY = (additions, deletions) -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)OPEN_BRACKET)).append((ComponentBuilder)Component.translatable().key("luckperms.command.editor.apply-edits.success-summary").args(new ComponentLike[]{Component.text((int)additions, (TextColor)NamedTextColor.GREEN), additions == 1 ? Component.translatable((String)"luckperms.command.editor.apply-edits.success.additions-singular") : Component.translatable((String)"luckperms.command.editor.apply-edits.success.additions"), Component.text((int)deletions, (TextColor)NamedTextColor.RED), deletions == 1 ? Component.translatable((String)"luckperms.command.editor.apply-edits.success.deletions-singular") : Component.translatable((String)"luckperms.command.editor.apply-edits.success.deletions")}))).append((Component)CLOSE_BRACKET));
    public static final Args1<Node> APPLY_EDIT_NODE = node -> ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.WHITE)).append((Component)Component.text((String)node.getKey()))).append((Component)Component.space())).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)OPEN_BRACKET)).append((Component)Component.text((boolean)node.getValue(), (TextColor)(node.getValue() ? NamedTextColor.GREEN : NamedTextColor.RED)))).append((Component)CLOSE_BRACKET))).apply(builder -> {
        if (!node.getContexts().isEmpty()) {
            builder.append((Component)Component.space());
            builder.append(Message.formatContextSetBracketed(node.getContexts(), (Component)Component.empty()));
        }
    })).apply(builder -> {
        if (node.hasExpiry()) {
            builder.append((Component)Component.space());
            builder.append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)OPEN_BRACKET)).append(DurationFormatter.CONCISE.format(node.getExpiryDuration()))).append((Component)CLOSE_BRACKET));
        }
    })).build();
    public static final Args1<Node> APPLY_EDITS_DIFF_ADDED = node -> ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((char)'+', (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)"  "))).append(APPLY_EDIT_NODE.build((Node)node))).build();
    public static final Args1<Node> APPLY_EDITS_DIFF_REMOVED = node -> ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((char)'-', (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"  "))).append(APPLY_EDIT_NODE.build((Node)node))).build();
    public static final Args1<List<String>> APPLY_EDITS_TRACK_AFTER = groups -> ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((char)'+', (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)"  "))).append(Message.formatTrackPath(groups))).build();
    public static final Args1<List<String>> APPLY_EDITS_TRACK_BEFORE = groups -> ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((char)'-', (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)"  "))).append(Message.formatTrackPath(groups))).build();
    public static final Args0 EDITOR_NO_MATCH = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().color((TextColor)NamedTextColor.RED)).key("luckperms.command.editor.no-match").append((Component)FULL_STOP));
    public static final Args0 EDITOR_START = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().color((TextColor)NamedTextColor.GRAY)).key("luckperms.command.editor.start"));
    public static final Args1<String> EDITOR_URL = url -> Message.joinNewline(new ComponentLike[]{Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.editor.url").color((TextColor)NamedTextColor.GREEN)).append((Component)Component.text((char)':'))), ((TextComponent.Builder)Component.text().content(url).color((TextColor)NamedTextColor.AQUA)).clickEvent(ClickEvent.openUrl((String)url))});
    public static final Args0 EDITOR_SOCKET_CONNECTED = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().color((TextColor)NamedTextColor.AQUA)).key("luckperms.command.editor.socket.connected").append((Component)FULL_STOP));
    public static final Args0 EDITOR_SOCKET_RECONNECTED = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().color((TextColor)NamedTextColor.GRAY)).key("luckperms.command.editor.socket.reconnected").append((Component)FULL_STOP));
    public static final Args0 EDITOR_SOCKET_CHANGES_RECEIVED = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().color((TextColor)NamedTextColor.GRAY)).key("luckperms.command.editor.socket.changes-received").append((Component)FULL_STOP));
    public static final Args4<String, String, String, Boolean> EDITOR_SOCKET_UNTRUSTED = (nonce, browser, cmdLabel, console) -> Message.joinNewline(new ComponentLike[]{Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.editor.socket.untrusted").color((TextColor)NamedTextColor.AQUA)).append((Component)FULL_STOP)), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_GRAY)).append((Component)OPEN_BRACKET)).append((ComponentBuilder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.editor.socket.untrusted.sessioninfo").color((TextColor)NamedTextColor.GRAY)).args(new ComponentLike[]{Component.text((String)nonce, (TextColor)NamedTextColor.WHITE), Component.text((String)browser, (TextColor)NamedTextColor.WHITE)}))).append((Component)CLOSE_BRACKET)), Message.prefixed((ComponentLike)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).apply(builder -> {
        String command = "/" + cmdLabel + " trusteditor " + nonce;
        if (console.booleanValue()) {
            builder.append((Component)Component.translatable().key("luckperms.command.editor.socket.untrusted.prompt.runcommand").args((Component)Component.text((String)command, (TextColor)NamedTextColor.GREEN)).build());
        } else {
            builder.append((Component)Component.translatable().key("luckperms.command.editor.socket.untrusted.prompt.click").args(((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.editor.socket.untrusted.prompt.click.action").color((TextColor)NamedTextColor.GREEN)).clickEvent(ClickEvent.runCommand((String)command))).build());
        }
    }))});
    public static final Args0 EDITOR_SOCKET_TRUST_SUCCESS = () -> Message.joinNewline(new ComponentLike[]{Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.editor.socket.trust.success").color((TextColor)NamedTextColor.GREEN)).append((Component)FULL_STOP)), Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.editor.socket.trust.futureinfo").color((TextColor)NamedTextColor.GRAY)).append((Component)FULL_STOP)), Message.prefixed((ComponentLike)Component.translatable().key("luckperms.command.editor.socket.trust.connecting").color((TextColor)NamedTextColor.GRAY))});
    public static final Args0 EDITOR_SOCKET_TRUST_FAILURE = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().color((TextColor)NamedTextColor.RED)).key("luckperms.command.editor.socket.trust.failure").append((Component)FULL_STOP));
    public static final Args2<Integer, String> EDITOR_HTTP_REQUEST_FAILURE = (code, message) -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.RED)).append((Component)Component.translatable((String)"luckperms.command.editor.unable-to-communicate"))).append((Component)FULL_STOP)).append((Component)Component.space())).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)OPEN_BRACKET)).append((Component)Component.translatable((String)"luckperms.command.misc.response-code-key"))).append((Component)Component.space())).append((Component)Component.text((int)code))).append((Component)Component.text((String)", "))).append((Component)Component.translatable((String)"luckperms.command.misc.error-message-key"))).append((Component)Component.text((String)"='"))).append((Component)Component.text((String)message))).append((Component)Component.text((String)"'"))).append((Component)CLOSE_BRACKET)));
    public static final Args0 EDITOR_HTTP_UNKNOWN_FAILURE = () -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.RED)).append((Component)Component.translatable((String)"luckperms.command.editor.unable-to-communicate"))).append((Component)FULL_STOP)).append((Component)Component.space())).append((Component)Component.translatable((String)"luckperms.command.misc.check-console-for-errors"))).append((Component)FULL_STOP));
    public static final Args1<Component> CREATE_SUCCESS = name -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().color((TextColor)NamedTextColor.GREEN)).key("luckperms.command.generic.create.success").args(((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(name)).append((Component)FULL_STOP));
    public static final Args1<Component> DELETE_SUCCESS = name -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().color((TextColor)NamedTextColor.GREEN)).key("luckperms.command.generic.delete.success").args(((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(name)).append((Component)FULL_STOP));
    public static final Args2<Component, Component> RENAME_SUCCESS = (from, to) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().color((TextColor)NamedTextColor.GREEN)).key("luckperms.command.generic.rename.success").args(new ComponentBuilder[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(from), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(to)}).append((Component)FULL_STOP));
    public static final Args2<Component, Component> CLONE_SUCCESS = (from, to) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().color((TextColor)NamedTextColor.GREEN)).key("luckperms.command.generic.clone.success").args(new ComponentBuilder[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(from), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(to)}).append((Component)FULL_STOP));
    public static final Args3<PermissionHolder, Group, ContextSet> ALREADY_INHERITS = (holder, group, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().color((TextColor)NamedTextColor.GREEN)).key("luckperms.command.generic.parent.already-inherits").args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(group.getFormattedDisplayName()), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args3<PermissionHolder, Component, ContextSet> DOES_NOT_INHERIT = (holder, group, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().color((TextColor)NamedTextColor.GREEN)).key("luckperms.command.generic.parent.doesnt-inherit").args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(group), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args3<PermissionHolder, Group, ContextSet> ALREADY_TEMP_INHERITS = (holder, group, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().color((TextColor)NamedTextColor.GREEN)).key("luckperms.command.generic.parent.already-temp-inherits").args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(group.getFormattedDisplayName()), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args3<PermissionHolder, Component, ContextSet> DOES_NOT_TEMP_INHERIT = (holder, group, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().color((TextColor)NamedTextColor.GREEN)).key("luckperms.command.generic.parent.doesnt-temp-inherit").args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(group), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args2<String, Group> TRACK_ALREADY_CONTAINS = (track, group) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().color((TextColor)NamedTextColor.GREEN)).key("luckperms.command.track.already-contains").args(new ComponentLike[]{Component.text((String)track, (TextColor)NamedTextColor.AQUA), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(group.getFormattedDisplayName())}).append((Component)FULL_STOP));
    public static final Args2<String, String> TRACK_DOES_NOT_CONTAIN = (track, group) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().color((TextColor)NamedTextColor.GREEN)).key("luckperms.command.track.doesnt-contain").args(new ComponentLike[]{Component.text((String)track, (TextColor)NamedTextColor.AQUA), Component.text((String)group, (TextColor)NamedTextColor.AQUA)}).append((Component)FULL_STOP));
    public static final Args1<User> TRACK_AMBIGUOUS_CALL = user -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().color((TextColor)NamedTextColor.RED)).key("luckperms.command.track.error-multiple-groups").args(((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_RED)).append(user.getFormattedDisplayName())).append((Component)FULL_STOP)).append((Component)Component.space())).append((Component)Component.translatable((String)"luckperms.command.track.error-ambiguous"))).append((Component)FULL_STOP));
    public static final Args1<String> ALREADY_EXISTS = name -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().color((TextColor)NamedTextColor.RED)).key("luckperms.command.generic.create.error-already-exists").args((Component)Component.text((String)name, (TextColor)NamedTextColor.DARK_RED)).append((Component)FULL_STOP));
    public static final Args1<String> DOES_NOT_EXIST = name -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().color((TextColor)NamedTextColor.RED)).key("luckperms.command.generic.delete.error-doesnt-exist").args((Component)Component.text((String)name, (TextColor)NamedTextColor.DARK_RED)).append((Component)FULL_STOP));
    public static final Args0 USER_LOAD_ERROR = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().color((TextColor)NamedTextColor.RED)).key("luckperms.command.misc.loading.error.unexpected").append((Component)FULL_STOP)).append((Component)Component.space())).append((Component)Component.translatable((String)"luckperms.command.misc.loading.error.user"))).append((Component)FULL_STOP));
    public static final Args0 GROUP_LOAD_ERROR = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().color((TextColor)NamedTextColor.RED)).key("luckperms.command.misc.loading.error.unexpected").append((Component)FULL_STOP)).append((Component)Component.space())).append((Component)Component.translatable((String)"luckperms.command.misc.loading.error.group"))).append((Component)FULL_STOP));
    public static final Args0 GROUPS_LOAD_ERROR = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().color((TextColor)NamedTextColor.RED)).key("luckperms.command.misc.loading.error.unexpected").append((Component)FULL_STOP)).append((Component)Component.space())).append((Component)Component.translatable((String)"luckperms.command.misc.loading.error.all-groups"))).append((Component)FULL_STOP));
    public static final Args0 TRACK_LOAD_ERROR = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().color((TextColor)NamedTextColor.RED)).key("luckperms.command.misc.loading.error.unexpected").append((Component)FULL_STOP)).append((Component)Component.space())).append((Component)Component.translatable((String)"luckperms.command.misc.loading.error.track"))).append((Component)FULL_STOP));
    public static final Args0 TRACKS_LOAD_ERROR = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().color((TextColor)NamedTextColor.RED)).key("luckperms.command.misc.loading.error.unexpected").append((Component)FULL_STOP)).append((Component)Component.space())).append((Component)Component.translatable((String)"luckperms.command.misc.loading.error.all-tracks"))).append((Component)FULL_STOP));
    public static final Args1<String> TRACK_EMPTY = name -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().color((TextColor)NamedTextColor.RED)).key("luckperms.command.track.error-empty").args((Component)Component.text((String)name, (TextColor)NamedTextColor.DARK_RED)).append((Component)FULL_STOP));
    public static final Args0 UPDATE_TASK_REQUEST = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().color((TextColor)NamedTextColor.AQUA)).key("luckperms.command.update-task.request").append((Component)FULL_STOP));
    public static final Args0 UPDATE_TASK_COMPLETE = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().color((TextColor)NamedTextColor.GREEN)).key("luckperms.command.update-task.complete").append((Component)FULL_STOP));
    public static final Args0 UPDATE_TASK_COMPLETE_NETWORK = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().color((TextColor)NamedTextColor.GREEN)).key("luckperms.command.update-task.complete").append((Component)FULL_STOP)).append((Component)Component.space())).append((Component)Component.translatable((String)"luckperms.command.update-task.push.attempting"))).append((Component)FULL_STOP));
    public static final Args1<String> UPDATE_TASK_PUSH_SUCCESS = serviceName -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().color((TextColor)NamedTextColor.GREEN)).key("luckperms.command.update-task.push.complete").args((Component)Component.text((String)(serviceName + " Messaging"), (TextColor)NamedTextColor.AQUA)).append((Component)FULL_STOP));
    public static final Args0 UPDATE_TASK_PUSH_FAILURE = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().color((TextColor)NamedTextColor.RED)).key("luckperms.command.update-task.push.error").append((Component)FULL_STOP));
    public static final Args0 UPDATE_TASK_PUSH_FAILURE_NOT_SETUP = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().color((TextColor)NamedTextColor.RED)).key("luckperms.command.update-task.push.error-not-setup").append((Component)FULL_STOP));
    public static final Args0 RELOAD_CONFIG_SUCCESS = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.reload-config.success").color((TextColor)NamedTextColor.GREEN)).append((Component)FULL_STOP)).append((Component)Component.space())).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)OPEN_BRACKET)).append((Component)Component.translatable((String)"luckperms.command.reload-config.restart-note"))).append((Component)CLOSE_BRACKET)));
    public static final Args2<LuckPermsPlugin, Map<Component, Component>> INFO = (plugin, storageMeta) -> Message.joinNewline(new ComponentLike[]{Message.prefixed((ComponentLike)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.info.running-plugin").color((TextColor)NamedTextColor.DARK_GREEN)).append((Component)Component.space())).append((Component)Component.text((String)AbstractLuckPermsPlugin.getPluginName(), (TextColor)NamedTextColor.AQUA))).append((Component)Component.space())).append((Component)Component.text((String)("v" + plugin.getBootstrap().getVersion()), (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)" by "))).append((Component)Component.text((String)"Luck", (TextColor)NamedTextColor.AQUA))).append((Component)FULL_STOP)), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append((Component)Component.text((String)"-  ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.translatable((String)"luckperms.command.info.platform-key"))).append((Component)Component.text((String)": "))).append((Component)Component.text((String)plugin.getBootstrap().getType().getFriendlyName(), (TextColor)NamedTextColor.WHITE))), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append((Component)Component.text((String)"-  ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.translatable((String)"luckperms.command.info.server-brand-key"))).append((Component)Component.text((String)": "))).append((Component)Component.text((String)plugin.getBootstrap().getServerBrand(), (TextColor)NamedTextColor.WHITE))), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append((Component)Component.text((String)"-  ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.translatable((String)"luckperms.command.info.server-version-key"))).append((Component)Component.text((char)':'))), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.WHITE)).append((Component)Component.text((String)"     "))).append((Component)Component.text((String)plugin.getBootstrap().getServerVersion()))), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append((Component)Component.text((String)"-  ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.translatable((String)"luckperms.command.info.storage-key"))).append((Component)Component.text((char)':'))), Message.prefixed((ComponentLike)Component.text().apply(builder -> {
        builder.append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append((Component)Component.text((String)"     "))).append((Component)Component.translatable((String)"luckperms.command.info.storage-type-key"))).append((Component)Component.text((String)": "))).append((Component)Component.text((String)plugin.getStorage().getName(), (TextColor)NamedTextColor.WHITE)));
        for (Map.Entry metaEntry : storageMeta.entrySet()) {
            builder.append((Component)Component.newline());
            builder.append((Component)Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append((Component)Component.text((String)"     "))).append((Component)metaEntry.getKey())).append((Component)Component.text((String)": "))).append((Component)metaEntry.getValue())));
        }
    })), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append((Component)Component.text((String)"-  ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.translatable((String)"luckperms.command.info.extensions-key"))).append((Component)Component.text((char)':'))), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.WHITE)).append((Component)Component.text((String)"     "))).append(Message.formatStringList(plugin.getExtensionManager().getLoadedExtensions().stream().map(e -> e.getClass().getSimpleName()).collect(Collectors.toList())))), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append((Component)Component.text((String)"-  ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.translatable((String)"luckperms.command.info.messaging-key"))).append((Component)Component.text((String)": "))).append(plugin.getMessagingService().map(s -> Component.text((String)s.getName(), (TextColor)NamedTextColor.WHITE)).orElse((Component)Component.translatable((String)"luckperms.command.misc.none", (TextColor)NamedTextColor.WHITE)))), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append((Component)Component.text((String)"-  ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.translatable((String)"luckperms.command.info.instance-key"))).append((Component)Component.text((char)':'))), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append((Component)Component.text((String)"     "))).append((Component)Component.translatable((String)"luckperms.command.info.static-contexts-key"))).append((Component)Component.text((String)": "))).append(Message.formatContextSetBracketed(plugin.getContextManager().getStaticContext(), (Component)Component.translatable((String)"luckperms.command.misc.none", (TextColor)NamedTextColor.WHITE)))), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append((Component)Component.text((String)"     "))).append((Component)Component.translatable((String)"luckperms.command.info.online-players-key"))).append((Component)Component.text((String)": "))).append((Component)Component.text((int)plugin.getBootstrap().getPlayerCount(), (TextColor)NamedTextColor.WHITE))).append((Component)Component.space())).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)OPEN_BRACKET)).append((ComponentBuilder)Component.translatable().key("luckperms.command.info.online-players-unique").args((Component)Component.text((int)plugin.getConnectionListener().getUniqueConnections().size(), (TextColor)NamedTextColor.GREEN)))).append((Component)CLOSE_BRACKET))), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append((Component)Component.text((String)"     "))).append((Component)Component.translatable((String)"luckperms.command.info.uptime-key"))).append((Component)Component.text((String)": "))).append(((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append(DurationFormatter.CONCISE_LOW_ACCURACY.format(Duration.between(plugin.getBootstrap().getStartupTime(), Instant.now()))))), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append((Component)Component.text((String)"     "))).append((Component)Component.translatable((String)"luckperms.command.info.local-data-key"))).append((Component)Component.text((String)": "))).append((ComponentBuilder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.info.local-data").color((TextColor)NamedTextColor.GRAY)).args(new ComponentLike[]{Component.text((int)plugin.getUserManager().getAll().size(), (TextColor)NamedTextColor.GREEN), Component.text((int)plugin.getGroupManager().getAll().size(), (TextColor)NamedTextColor.GREEN), Component.text((int)plugin.getTrackManager().getAll().size(), (TextColor)NamedTextColor.GREEN)})))});
    public static final Args1<Component> CREATE_ERROR = name -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.create.error").color((TextColor)NamedTextColor.RED)).args(((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_RED)).append(name)).append((Component)FULL_STOP));
    public static final Args1<Component> DELETE_ERROR = name -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.delete.error").color((TextColor)NamedTextColor.RED)).args(((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_RED)).append(name)).append((Component)FULL_STOP));
    public static final Args0 DELETE_GROUP_ERROR_DEFAULT = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.group.delete.not-default").color((TextColor)NamedTextColor.RED)).append((Component)FULL_STOP));
    public static final Args0 GROUPS_LIST = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.group.list.title").color((TextColor)NamedTextColor.GREEN)).append((Component)Component.text((String)": "))).append((Component)Component.text((String)"(name, weight, tracks)", (TextColor)NamedTextColor.GRAY)));
    public static final Args3<Group, Integer, Collection<String>> GROUPS_LIST_ENTRY = (group, weight, tracks) -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"-  ", (TextColor)NamedTextColor.WHITE))).append(((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append(group.getFormattedDisplayName()))).append((Component)Component.text((String)" - ", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((int)weight, (TextColor)NamedTextColor.AQUA))).apply(builder -> {
        if (!tracks.isEmpty()) {
            builder.append((Component)Component.text((String)" - ", (TextColor)NamedTextColor.GRAY));
            builder.append(Message.formatStringList(tracks));
        }
    }));
    public static final Args1<Collection<String>> TRACKS_LIST = list -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.track.list.title").color((TextColor)NamedTextColor.GREEN)).append((Component)Component.text((String)": "))).append(Message.formatStringList(list)));
    public static final Args4<PermissionHolder, Integer, Integer, Integer> PERMISSION_INFO = (holder, page, totalPages, totalEntries) -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append((ComponentBuilder)Component.translatable().key("luckperms.command.generic.permission.info.title").args(holder.getFormattedDisplayName()))).append((Component)Component.text((char)':'))).append((Component)Component.text((String)"  "))).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)OPEN_BRACKET)).append((ComponentBuilder)Component.translatable().key("luckperms.command.misc.page").args(new ComponentLike[]{Component.text((int)page, (TextColor)NamedTextColor.WHITE), Component.text((int)totalPages, (TextColor)NamedTextColor.WHITE)}))).append((Component)Component.text((String)" - "))).append((ComponentBuilder)Component.translatable().key("luckperms.command.misc.page-entries").args((Component)Component.text((int)totalEntries, (TextColor)NamedTextColor.WHITE)))).append((Component)CLOSE_BRACKET)));
    public static final Args1<PermissionHolder> PERMISSION_INFO_NO_DATA = holder -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.permission.info.empty").color((TextColor)NamedTextColor.GREEN)).args(((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName())).append((Component)FULL_STOP));
    public static final Args3<Node, PermissionHolder, String> PERMISSION_INFO_NODE_ENTRY = (node, holder, label) -> ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((char)'>', (TextColor)NamedTextColor.DARK_AQUA))).append((Component)Component.space())).append((Component)Component.text((String)node.getKey(), (TextColor)(node.getValue() ? NamedTextColor.GREEN : NamedTextColor.RED)))).append((Component)Component.space())).append(Message.formatContextSetBracketed(node.getContexts(), (Component)Component.empty()))).apply(builder -> {
        String holderName = holder.getType() == HolderType.GROUP ? holder.getIdentifier().getName() : holder.getPlainDisplayName();
        boolean explicitGlobalContext = !holder.getPlugin().getConfiguration().getContextsFile().getDefaultContexts().isEmpty();
        Component hover = Message.joinNewline(new ComponentLike[]{((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((char)'>', (TextColor)NamedTextColor.DARK_AQUA))).append((Component)Component.space())).append((Component)Component.text((String)node.getKey(), (TextColor)(node.getValue() ? NamedTextColor.GREEN : NamedTextColor.RED))), Component.text(), ((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.permission.info.click-to-remove").color((TextColor)NamedTextColor.GRAY)).args((Component)Component.text((String)holderName))});
        String command = "/" + label + " " + NodeCommandFactory.undoCommand(node, holderName, holder.getType(), explicitGlobalContext);
        builder.hoverEvent((HoverEventSource)HoverEvent.showText((Component)hover));
        builder.clickEvent(ClickEvent.suggestCommand((String)command));
    })).build();
    public static final Args3<Node, PermissionHolder, String> PERMISSION_INFO_TEMPORARY_NODE_ENTRY = (node, holder, label) -> Message.joinNewline(new ComponentLike[]{((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((char)'>', (TextColor)NamedTextColor.DARK_AQUA))).append((Component)Component.space())).append((Component)Component.text((String)node.getKey(), (TextColor)(node.getValue() ? NamedTextColor.GREEN : NamedTextColor.RED)))).append((Component)Component.space())).append(Message.formatContextSetBracketed(node.getContexts(), (Component)Component.empty()))).apply(builder -> {
        String holderName = holder.getType() == HolderType.GROUP ? holder.getIdentifier().getName() : holder.getPlainDisplayName();
        boolean explicitGlobalContext = !holder.getPlugin().getConfiguration().getContextsFile().getDefaultContexts().isEmpty();
        Component hover = Message.joinNewline(new ComponentLike[]{((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((char)'>', (TextColor)NamedTextColor.DARK_AQUA))).append((Component)Component.space())).append((Component)Component.text((String)node.getKey(), (TextColor)(node.getValue() ? NamedTextColor.GREEN : NamedTextColor.RED))), Component.text(), ((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.permission.info.click-to-remove").color((TextColor)NamedTextColor.GRAY)).args((Component)Component.text((String)holderName))});
        String command = "/" + label + " " + NodeCommandFactory.undoCommand(node, holderName, holder.getType(), explicitGlobalContext);
        builder.hoverEvent((HoverEventSource)HoverEvent.showText((Component)hover));
        builder.clickEvent(ClickEvent.suggestCommand((String)command));
    })).build(), ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_GREEN)).append((Component)Component.text((String)"-    "))).append((Component)Component.translatable((String)"luckperms.command.generic.info.expires-in"))).append((Component)Component.space())).append(DurationFormatter.LONG.format(node.getExpiryDuration()))).build()});
    public static final Args4<PermissionHolder, Integer, Integer, Integer> PARENT_INFO = (holder, page, totalPages, totalEntries) -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append((ComponentBuilder)Component.translatable().key("luckperms.command.generic.parent.info.title").args(holder.getFormattedDisplayName()))).append((Component)Component.text((char)':'))).append((Component)Component.text((String)"  "))).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)OPEN_BRACKET)).append((ComponentBuilder)Component.translatable().key("luckperms.command.misc.page").args(new ComponentLike[]{Component.text((int)page, (TextColor)NamedTextColor.WHITE), Component.text((int)totalPages, (TextColor)NamedTextColor.WHITE)}))).append((Component)Component.text((String)" - "))).append((ComponentBuilder)Component.translatable().key("luckperms.command.misc.page-entries").args((Component)Component.text((int)totalEntries, (TextColor)NamedTextColor.WHITE)))).append((Component)CLOSE_BRACKET)));
    public static final Args1<PermissionHolder> PARENT_INFO_NO_DATA = holder -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.parent.info.empty").color((TextColor)NamedTextColor.GREEN)).args(((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName())).append((Component)FULL_STOP));
    public static final Args3<InheritanceNode, PermissionHolder, String> PARENT_INFO_NODE_ENTRY = (node, holder, label) -> ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((char)'>', (TextColor)NamedTextColor.DARK_AQUA))).append((Component)Component.space())).append(((TextComponent.Builder)Component.text().content(node.getGroupName()).color((TextColor)NamedTextColor.GREEN)).apply(builder -> {
        String holderName = holder.getType() == HolderType.GROUP ? holder.getIdentifier().getName() : holder.getPlainDisplayName();
        boolean explicitGlobalContext = !holder.getPlugin().getConfiguration().getContextsFile().getDefaultContexts().isEmpty();
        Component hover = Message.joinNewline(new ComponentLike[]{((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((char)'>', (TextColor)NamedTextColor.DARK_AQUA))).append((Component)Component.space())).append((Component)Component.text((String)node.getGroupName(), (TextColor)NamedTextColor.WHITE)), Component.text(), ((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.parent.info.click-to-remove").color((TextColor)NamedTextColor.GRAY)).args((Component)Component.text((String)holderName))});
        String command = "/" + label + " " + NodeCommandFactory.undoCommand(node, holderName, holder.getType(), explicitGlobalContext);
        builder.hoverEvent((HoverEventSource)HoverEvent.showText((Component)hover));
        builder.clickEvent(ClickEvent.suggestCommand((String)command));
    }))).append((Component)Component.space())).append(Message.formatContextSetBracketed(node.getContexts(), (Component)Component.empty()))).build();
    public static final Args3<InheritanceNode, PermissionHolder, String> PARENT_INFO_TEMPORARY_NODE_ENTRY = (node, holder, label) -> Message.joinNewline(new ComponentLike[]{((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((char)'>', (TextColor)NamedTextColor.DARK_AQUA))).append((Component)Component.space())).append(((TextComponent.Builder)Component.text().content(node.getGroupName()).color((TextColor)NamedTextColor.GREEN)).apply(builder -> {
        String holderName = holder.getType() == HolderType.GROUP ? holder.getIdentifier().getName() : holder.getPlainDisplayName();
        boolean explicitGlobalContext = !holder.getPlugin().getConfiguration().getContextsFile().getDefaultContexts().isEmpty();
        Component hover = Message.joinNewline(new ComponentLike[]{((TextComponent.Builder)Component.text().append((Component)Component.text((char)'>', (TextColor)NamedTextColor.DARK_AQUA))).append((Component)Component.text((String)node.getGroupName(), (TextColor)NamedTextColor.WHITE)), Component.text(), ((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.permission.info.click-to-remove").color((TextColor)NamedTextColor.GRAY)).args((Component)Component.text((String)holderName))});
        String command = "/" + label + " " + NodeCommandFactory.undoCommand(node, holderName, holder.getType(), explicitGlobalContext);
        builder.hoverEvent((HoverEventSource)HoverEvent.showText((Component)hover));
        builder.clickEvent(ClickEvent.suggestCommand((String)command));
    }))).append((Component)Component.space())).append(Message.formatContextSetBracketed(node.getContexts(), (Component)Component.empty()))).build(), ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_GREEN)).append((Component)Component.text((String)"-    "))).append((Component)Component.translatable((String)"luckperms.command.generic.info.expires-in"))).append((Component)Component.space())).append(DurationFormatter.LONG.format(node.getExpiryDuration()))).build()});
    public static final Args1<PermissionHolder> LIST_TRACKS = holder -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.show-tracks.title").color((TextColor)NamedTextColor.AQUA)).args(holder.getFormattedDisplayName()).append((Component)Component.text((char)':')));
    public static final Args3<String, ContextSet, Component> LIST_TRACKS_ENTRY = (name, contextSet, path) -> Message.joinNewline(new ComponentLike[]{((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((char)'>', (TextColor)NamedTextColor.DARK_AQUA))).append((Component)Component.space())).append((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GREEN)).append((Component)Component.text((String)name))).append((Component)Component.text((String)": "))).append(Message.formatContextSetBracketed(contextSet, (Component)Component.empty()))).build()), ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)Component.text((String)"  "))).append((Component)OPEN_BRACKET)).append(path)).append((Component)CLOSE_BRACKET)});
    public static final Args1<PermissionHolder> LIST_TRACKS_EMPTY = holder -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.show-tracks.empty").color((TextColor)NamedTextColor.GREEN)).args(((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName())).append((Component)FULL_STOP));
    public static final Args1<String> PERMISSION_CHECK_INFO_HEADER = permission -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.permission.check.info.title").color((TextColor)NamedTextColor.GREEN)).args((Component)Component.text((String)permission, (TextColor)NamedTextColor.AQUA)).append((Component)Component.text((char)':')));
    public static final Args4<PermissionHolder, String, Tristate, ContextSet> PERMISSION_CHECK_INFO_DIRECTLY = (holder, permission, value, context) -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((char)'-', (TextColor)NamedTextColor.WHITE))).append((Component)Component.space())).append(((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.permission.check.info.directly").color((TextColor)NamedTextColor.GRAY)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), Component.text((String)permission, (TextColor)NamedTextColor.AQUA), Message.formatTristate(value), Message.formatContextSet(context)}).append((Component)FULL_STOP)));
    public static final Args5<PermissionHolder, String, Tristate, ContextSet, String> PERMISSION_CHECK_INFO_INHERITED = (holder, permission, value, context, inheritedFrom) -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((char)'-', (TextColor)NamedTextColor.WHITE))).append((Component)Component.space())).append(((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.permission.check.info.inherited").color((TextColor)NamedTextColor.GRAY)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), Component.text((String)permission, (TextColor)NamedTextColor.AQUA), Message.formatTristate(value), Component.text((String)inheritedFrom, (TextColor)NamedTextColor.GREEN), Message.formatContextSet(context)}).append((Component)FULL_STOP)));
    public static final Args2<PermissionHolder, String> PERMISSION_CHECK_INFO_NOT_DIRECTLY = (holder, permission) -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((char)'-', (TextColor)NamedTextColor.WHITE))).append((Component)Component.space())).append(((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.permission.check.info.not-directly").color((TextColor)NamedTextColor.GRAY)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), Component.text((String)permission, (TextColor)NamedTextColor.AQUA)}).append((Component)FULL_STOP)));
    public static final Args2<PermissionHolder, String> PERMISSION_CHECK_INFO_NOT_INHERITED = (holder, permission) -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((char)'-', (TextColor)NamedTextColor.WHITE))).append((Component)Component.space())).append(((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.permission.check.info.not-inherited").color((TextColor)NamedTextColor.GRAY)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), Component.text((String)permission, (TextColor)NamedTextColor.AQUA)}).append((Component)FULL_STOP)));
    public static final Args5<String, Tristate, String, Node, ContextSet> PERMISSION_CHECK_RESULT = (permission, result, processor, causeNode, context) -> Message.joinNewline(new ComponentLike[]{Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.permission.check.result.title").color((TextColor)NamedTextColor.GREEN)).args((Component)Component.text((String)permission, (TextColor)NamedTextColor.AQUA)).append((Component)Component.text((char)':'))), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append((Component)Component.text((String)"    "))).append((Component)Component.translatable((String)"luckperms.command.generic.permission.check.result.result-key"))).append((Component)Component.text((String)": "))).append(Message.formatTristate(result))), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append((Component)Component.text((String)"    "))).append((Component)Component.translatable((String)"luckperms.command.generic.permission.check.result.processor-key"))).append((Component)Component.text((String)": "))).apply(builder -> {
        if (processor == null) {
            builder.append((Component)Component.translatable((String)"luckperms.command.misc.none", (TextColor)NamedTextColor.AQUA));
        } else {
            builder.append((Component)Component.text((String)processor, (TextColor)NamedTextColor.WHITE));
        }
    })), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append((Component)Component.text((String)"    "))).append((Component)Component.translatable((String)"luckperms.command.generic.permission.check.result.cause-key"))).append((Component)Component.text((String)": "))).apply(builder -> {
        if (causeNode == null) {
            builder.append((Component)Component.translatable((String)"luckperms.command.misc.none", (TextColor)NamedTextColor.AQUA));
        } else {
            String origin = causeNode.getMetadata(InheritanceOriginMetadata.KEY).map(o -> o.getOrigin().getName()).orElse("?");
            builder.append((ComponentBuilder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.permission.check.info.directly").color((TextColor)NamedTextColor.GRAY)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).content(origin), Component.text((String)causeNode.getKey(), (TextColor)NamedTextColor.AQUA), Message.formatBoolean(causeNode.getValue()), Message.formatContextSet(causeNode.getContexts())}));
        }
    })), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append((Component)Component.text((String)"    "))).append((Component)Component.translatable((String)"luckperms.command.generic.permission.check.result.context-key"))).append((Component)Component.text((String)": "))).append(Message.formatContextSetBracketed(context, (Component)Component.translatable((String)"luckperms.command.misc.none", (TextColor)NamedTextColor.AQUA))))});
    public static final Args4<String, Boolean, PermissionHolder, ContextSet> SETPERMISSION_SUCCESS = (permission, value, holder, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.permission.set").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{Component.text((String)permission, (TextColor)NamedTextColor.AQUA), Component.text((boolean)value, (TextColor)NamedTextColor.AQUA), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args3<PermissionHolder, String, ContextSet> ALREADY_HASPERMISSION = (holder, permission, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.permission.already-has").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), Component.text((String)permission, (TextColor)NamedTextColor.AQUA), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args5<String, Boolean, PermissionHolder, Duration, ContextSet> SETPERMISSION_TEMP_SUCCESS = (permission, value, holder, duration, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.permission.set-temp").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{Component.text((String)permission, (TextColor)NamedTextColor.AQUA), Component.text((boolean)value, (TextColor)NamedTextColor.AQUA), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(DurationFormatter.LONG.format((Duration)duration)), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args3<PermissionHolder, String, ContextSet> ALREADY_HAS_TEMP_PERMISSION = (holder, permission, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.permission.already-has-temp").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), Component.text((String)permission, (TextColor)NamedTextColor.AQUA), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args3<String, PermissionHolder, ContextSet> UNSETPERMISSION_SUCCESS = (permission, holder, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.permission.unset").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{Component.text((String)permission, (TextColor)NamedTextColor.AQUA), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args3<PermissionHolder, String, ContextSet> DOES_NOT_HAVE_PERMISSION = (holder, permission, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.permission.doesnt-have").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), Component.text((String)permission, (TextColor)NamedTextColor.AQUA), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args3<String, PermissionHolder, ContextSet> UNSET_TEMP_PERMISSION_SUCCESS = (permission, holder, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.permission.unset-temp").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{Component.text((String)permission, (TextColor)NamedTextColor.AQUA), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args6<String, Boolean, PermissionHolder, Duration, ContextSet, Duration> UNSET_TEMP_PERMISSION_SUBTRACT_SUCCESS = (permission, value, holder, duration, context, durationLess) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.permission.subtract").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{Component.text((String)permission, (TextColor)NamedTextColor.AQUA), Component.text((boolean)value, (TextColor)NamedTextColor.AQUA), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(DurationFormatter.LONG.format((Duration)duration)), Message.formatContextSet(context), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(DurationFormatter.LONG.format((Duration)durationLess))}).append((Component)FULL_STOP));
    public static final Args3<PermissionHolder, String, ContextSet> DOES_NOT_HAVE_TEMP_PERMISSION = (holder, permission, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.permission.doesnt-have-temp").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), Component.text((String)permission, (TextColor)NamedTextColor.AQUA), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args1<String> INVALID_INPUT_EMPTY = s -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.misc.invalid-input-empty-" + s).color((TextColor)NamedTextColor.RED)).append((Component)FULL_STOP));
    public static final Args0 INVALID_PERMISSION_EMPTY = () -> INVALID_INPUT_EMPTY.build("permission");
    public static final Args0 INVALID_META_KEY_EMPTY = () -> INVALID_INPUT_EMPTY.build("meta-key");
    public static final Args0 INVALID_DISPLAY_NAME_EMPTY = () -> INVALID_INPUT_EMPTY.build("display-name");
    public static final Args3<PermissionHolder, Group, ContextSet> SET_INHERIT_SUCCESS = (holder, parent, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.parent.add").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(parent.getFormattedDisplayName()), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args4<PermissionHolder, Group, Duration, ContextSet> SET_TEMP_INHERIT_SUCCESS = (holder, parent, duration, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.parent.add-temp").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(parent.getFormattedDisplayName()), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(DurationFormatter.LONG.format((Duration)duration)), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args3<PermissionHolder, Group, ContextSet> SET_PARENT_SUCCESS = (holder, parent, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.parent.set").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(parent.getFormattedDisplayName()), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args4<PermissionHolder, String, Group, ContextSet> SET_TRACK_PARENT_SUCCESS = (holder, track, parent, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.parent.set-track").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), Component.text((String)track, (TextColor)NamedTextColor.AQUA), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(parent.getFormattedDisplayName()), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args3<PermissionHolder, Component, ContextSet> UNSET_INHERIT_SUCCESS = (holder, parent, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.parent.remove").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(parent), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args3<PermissionHolder, Component, ContextSet> UNSET_TEMP_INHERIT_SUCCESS = (holder, parent, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.parent.remove-temp").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(parent), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args5<PermissionHolder, Component, Duration, ContextSet, Duration> UNSET_TEMP_INHERIT_SUBTRACT_SUCCESS = (holder, parent, duration, context, durationLess) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.parent.subtract").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(parent), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(DurationFormatter.LONG.format((Duration)duration)), Message.formatContextSet(context), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(DurationFormatter.LONG.format((Duration)durationLess))}).append((Component)FULL_STOP));
    public static final Args3<PermissionHolder, ContextSet, Integer> CLEAR_SUCCESS = (holder, context, removeCount) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.clear").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), Message.formatContextSet(context)}).append((Component)FULL_STOP)).append((Component)Component.space())).append(((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)OPEN_BRACKET)).append(((TranslatableComponent.Builder)Component.translatable().key(removeCount == 1 ? "luckperms.command.generic.clear.node-removed-singular" : "luckperms.command.generic.clear.node-removed").args((Component)Component.text((int)removeCount)).color((TextColor)NamedTextColor.AQUA)).append((Component)FULL_STOP))).append((Component)CLOSE_BRACKET)));
    public static final Args3<PermissionHolder, ContextSet, Integer> PERMISSION_CLEAR_SUCCESS = (holder, context, removeCount) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.permission.clear").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), Message.formatContextSet(context)}).append((Component)FULL_STOP)).append((Component)Component.space())).append(((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)OPEN_BRACKET)).append(((TranslatableComponent.Builder)Component.translatable().key(removeCount == 1 ? "luckperms.command.generic.clear.node-removed-singular" : "luckperms.command.generic.clear.node-removed").args((Component)Component.text((int)removeCount)).color((TextColor)NamedTextColor.AQUA)).append((Component)FULL_STOP))).append((Component)CLOSE_BRACKET)));
    public static final Args3<PermissionHolder, ContextSet, Integer> PARENT_CLEAR_SUCCESS = (holder, context, removeCount) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.parent.clear").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), Message.formatContextSet(context)}).append((Component)FULL_STOP)).append((Component)Component.space())).append(((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)OPEN_BRACKET)).append(((TranslatableComponent.Builder)Component.translatable().key(removeCount == 1 ? "luckperms.command.generic.clear.node-removed-singular" : "luckperms.command.generic.clear.node-removed").args((Component)Component.text((int)removeCount)).color((TextColor)NamedTextColor.AQUA)).append((Component)FULL_STOP))).append((Component)CLOSE_BRACKET)));
    public static final Args4<PermissionHolder, String, ContextSet, Integer> PARENT_CLEAR_TRACK_SUCCESS = (holder, track, context, removeCount) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.parent.clear-track").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), Component.text((String)track, (TextColor)NamedTextColor.AQUA), Message.formatContextSet(context)}).append((Component)FULL_STOP)).append((Component)Component.space())).append(((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)OPEN_BRACKET)).append(((TranslatableComponent.Builder)Component.translatable().key(removeCount == 1 ? "luckperms.command.generic.clear.node-removed-singular" : "luckperms.command.generic.clear.node-removed").args((Component)Component.text((int)removeCount)).color((TextColor)NamedTextColor.AQUA)).append((Component)FULL_STOP))).append((Component)CLOSE_BRACKET)));
    public static final Args4<PermissionHolder, String, ContextSet, Integer> META_CLEAR_SUCCESS = (holder, key, context, removeCount) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.meta.clear").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), Component.text((String)key, (TextColor)NamedTextColor.AQUA), Message.formatContextSet(context)}).append((Component)FULL_STOP)).append((Component)Component.space())).append(((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)OPEN_BRACKET)).append(((TranslatableComponent.Builder)Component.translatable().key(removeCount == 1 ? "luckperms.command.generic.clear.node-removed-singular" : "luckperms.command.generic.clear.node-removed").args((Component)Component.text((int)removeCount)).color((TextColor)NamedTextColor.AQUA)).append((Component)FULL_STOP))).append((Component)CLOSE_BRACKET)));
    public static final Args1<String> ILLEGAL_DATE_ERROR = invalid -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.misc.date-parse-error").color((TextColor)NamedTextColor.RED)).args((Component)Component.text((String)invalid, (TextColor)NamedTextColor.DARK_RED)).append((Component)FULL_STOP));
    public static final Args0 PAST_DATE_ERROR = () -> Message.prefixed((ComponentLike)Component.translatable().key("luckperms.command.misc.date-in-past-error").color((TextColor)NamedTextColor.RED));
    public static final Args1<PermissionHolder> CHAT_META_PREFIX_HEADER = holder -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.chat-meta.info.title-prefix").color((TextColor)NamedTextColor.AQUA)).args(holder.getFormattedDisplayName()));
    public static final Args1<PermissionHolder> CHAT_META_SUFFIX_HEADER = holder -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.chat-meta.info.title-suffix").color((TextColor)NamedTextColor.AQUA)).args(holder.getFormattedDisplayName()));
    public static final Args1<PermissionHolder> META_HEADER = holder -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.meta.info.title").color((TextColor)NamedTextColor.AQUA)).args(holder.getFormattedDisplayName()));
    public static final Args3<ChatMetaNode<?, ?>, PermissionHolder, String> CHAT_META_ENTRY = (node, holder, label) -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"->", (TextColor)NamedTextColor.AQUA))).append((Component)Component.space())).append((Component)Component.text((int)node.getPriority(), (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)" - ", (TextColor)NamedTextColor.WHITE))).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.WHITE)).append((Component)Component.text((char)'\''))).append(Message.formatColoredValue(node.getMetaValue()))).append((Component)Component.text((char)'\'')))).apply(builder -> {
        if (node.hasExpiry()) {
            builder.append((Component)Component.space());
            builder.append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_GRAY)).append((Component)OPEN_BRACKET)).append(((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.info.expires-in").color((TextColor)NamedTextColor.GRAY)).append((Component)Component.space())).append(((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(DurationFormatter.CONCISE.format(node.getExpiryDuration()))))).append((Component)CLOSE_BRACKET));
        }
    })).append((Component)Component.space())).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_GRAY)).append((Component)OPEN_BRACKET)).append(((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().color((TextColor)NamedTextColor.GRAY)).key("luckperms.command.generic.info.inherited-from").append((Component)Component.space())).apply(builder -> {
        InheritanceOriginMetadata origin = node.metadata(InheritanceOriginMetadata.KEY);
        if (origin.wasInherited(holder.getIdentifier())) {
            builder.append((Component)Component.text((String)origin.getOrigin().getName(), (TextColor)NamedTextColor.GREEN));
        } else {
            builder.append((Component)Component.translatable((String)"luckperms.command.generic.info.inherited-from-self", (TextColor)NamedTextColor.GREEN));
        }
    })).append((Component)CLOSE_BRACKET))).append((Component)Component.space())).append(Message.formatContextSetBracketed(node.getContexts(), (Component)Component.empty()))).apply(builder -> {
        InheritanceOriginMetadata origin = node.metadata(InheritanceOriginMetadata.KEY);
        String originName = origin.wasInherited(holder.getIdentifier()) ? origin.getOrigin().getName() : holder.getPlainDisplayName();
        HolderType originType = HolderType.valueOf(origin.getOrigin().getType().toUpperCase(Locale.ROOT));
        boolean explicitGlobalContext = !holder.getPlugin().getConfiguration().getContextsFile().getDefaultContexts().isEmpty();
        Component hover = Message.joinNewline(new ComponentLike[]{((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((char)'>', (TextColor)NamedTextColor.DARK_AQUA))).append((Component)Component.space())).append((Component)Component.text((int)node.getPriority(), (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)" - ", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)node.getMetaValue(), (TextColor)NamedTextColor.WHITE)), Component.text(), ((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.chat-meta.info.click-to-remove").color((TextColor)NamedTextColor.GRAY)).args(new ComponentLike[]{Component.text((String)node.getMetaType().toString()), Component.text((String)originName)})});
        String command = "/" + label + " " + NodeCommandFactory.undoCommand(node, originName, originType, explicitGlobalContext);
        builder.hoverEvent((HoverEventSource)HoverEvent.showText((Component)hover));
        builder.clickEvent(ClickEvent.suggestCommand((String)command));
    })));
    public static final Args3<MetaNode, PermissionHolder, String> META_ENTRY = (node, holder, label) -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"->", (TextColor)NamedTextColor.AQUA))).append((Component)Component.space())).append((Component)Component.text((String)node.getMetaKey(), (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)" = ", (TextColor)NamedTextColor.WHITE))).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.WHITE)).append((Component)Component.text((char)'\''))).append(Message.formatColoredValue(node.getMetaValue()))).append((Component)Component.text((char)'\'')))).apply(builder -> {
        if (node.hasExpiry()) {
            builder.append((Component)Component.space());
            builder.append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_GRAY)).append((Component)OPEN_BRACKET)).append(((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.info.expires-in").color((TextColor)NamedTextColor.GRAY)).append((Component)Component.space())).append(((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(DurationFormatter.CONCISE.format(node.getExpiryDuration()))))).append((Component)CLOSE_BRACKET));
        }
    })).append((Component)Component.space())).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_GRAY)).append((Component)OPEN_BRACKET)).append(((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().color((TextColor)NamedTextColor.GRAY)).key("luckperms.command.generic.info.inherited-from").append((Component)Component.space())).apply(builder -> {
        InheritanceOriginMetadata origin = node.metadata(InheritanceOriginMetadata.KEY);
        if (origin.wasInherited(holder.getIdentifier())) {
            builder.append((Component)Component.text((String)origin.getOrigin().getName(), (TextColor)NamedTextColor.GREEN));
        } else {
            builder.append((Component)Component.translatable((String)"luckperms.command.generic.info.inherited-from-self", (TextColor)NamedTextColor.GREEN));
        }
    })).append((Component)CLOSE_BRACKET))).append((Component)Component.space())).append(Message.formatContextSetBracketed(node.getContexts(), (Component)Component.empty()))).apply(builder -> {
        InheritanceOriginMetadata origin = node.metadata(InheritanceOriginMetadata.KEY);
        String originName = origin.wasInherited(holder.getIdentifier()) ? origin.getOrigin().getName() : holder.getPlainDisplayName();
        HolderType originType = HolderType.valueOf(origin.getOrigin().getType().toUpperCase(Locale.ROOT));
        boolean explicitGlobalContext = !holder.getPlugin().getConfiguration().getContextsFile().getDefaultContexts().isEmpty();
        Component hover = Message.joinNewline(new ComponentLike[]{((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((char)'>', (TextColor)NamedTextColor.DARK_AQUA))).append((Component)Component.space())).append((Component)Component.text((String)node.getMetaKey(), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)" - ", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)node.getMetaValue(), (TextColor)NamedTextColor.WHITE)), Component.text(), ((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.meta.info.click-to-remove").color((TextColor)NamedTextColor.GRAY)).args((Component)Component.text((String)originName))});
        String command = "/" + label + " " + NodeCommandFactory.undoCommand(node, originName, originType, explicitGlobalContext);
        builder.hoverEvent((HoverEventSource)HoverEvent.showText((Component)hover));
        builder.clickEvent(ClickEvent.suggestCommand((String)command));
    })));
    public static final Args1<PermissionHolder> CHAT_META_PREFIX_NONE = holder -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.chat-meta.info.none-prefix").color((TextColor)NamedTextColor.AQUA)).args(holder.getFormattedDisplayName()).append((Component)FULL_STOP));
    public static final Args1<PermissionHolder> CHAT_META_SUFFIX_NONE = holder -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.chat-meta.info.none-suffix").color((TextColor)NamedTextColor.AQUA)).args(holder.getFormattedDisplayName()).append((Component)FULL_STOP));
    public static final Args1<PermissionHolder> META_NONE = holder -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.meta.info.none").color((TextColor)NamedTextColor.AQUA)).args(holder.getFormattedDisplayName()).append((Component)FULL_STOP));
    public static final Args1<String> META_INVALID_PRIORITY = invalid -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.misc.invalid-priority").color((TextColor)NamedTextColor.RED)).args((Component)Component.text((String)invalid, (TextColor)NamedTextColor.DARK_RED)).append((Component)FULL_STOP)).append((Component)Component.space())).append((Component)Component.translatable((String)"luckperms.command.misc.expected-number"))).append((Component)FULL_STOP));
    public static final Args5<PermissionHolder, ChatMetaType, String, Integer, ContextSet> ALREADY_HAS_CHAT_META = (holder, type, value, priority, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.chat-meta.already-has").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), Component.text((String)type.toString()), ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.WHITE)).append((Component)Component.text((char)'\''))).append(Message.formatColoredValue(value))).append((Component)Component.text((char)'\'')), Component.text((int)priority, (TextColor)NamedTextColor.AQUA), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args5<PermissionHolder, ChatMetaType, String, Integer, ContextSet> ALREADY_HAS_TEMP_CHAT_META = (holder, type, value, priority, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.chat-meta.already-has-temp").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), Component.text((String)type.toString()), ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.WHITE)).append((Component)Component.text((char)'\''))).append(Message.formatColoredValue(value))).append((Component)Component.text((char)'\'')), Component.text((int)priority, (TextColor)NamedTextColor.AQUA), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args5<PermissionHolder, ChatMetaType, String, Integer, ContextSet> DOES_NOT_HAVE_CHAT_META = (holder, type, value, priority, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.chat-meta.doesnt-have").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), Component.text((String)type.toString()), ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.WHITE)).append((Component)Component.text((char)'\''))).append(Message.formatColoredValue(value))).append((Component)Component.text((char)'\'')), Component.text((int)priority, (TextColor)NamedTextColor.AQUA), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args5<PermissionHolder, ChatMetaType, String, Integer, ContextSet> DOES_NOT_HAVE_TEMP_CHAT_META = (holder, type, value, priority, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.chat-meta.doesnt-have-temp").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), Component.text((String)type.toString()), ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.WHITE)).append((Component)Component.text((char)'\''))).append(Message.formatColoredValue(value))).append((Component)Component.text((char)'\'')), Component.text((int)priority, (TextColor)NamedTextColor.AQUA), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args5<PermissionHolder, ChatMetaType, String, Integer, ContextSet> ADD_CHATMETA_SUCCESS = (holder, type, value, priority, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.chat-meta.add").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), Component.text((String)type.toString()), ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.WHITE)).append((Component)Component.text((char)'\''))).append(Message.formatColoredValue(value))).append((Component)Component.text((char)'\'')), Component.text((int)priority, (TextColor)NamedTextColor.AQUA), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args6<PermissionHolder, ChatMetaType, String, Integer, Duration, ContextSet> ADD_TEMP_CHATMETA_SUCCESS = (holder, type, value, priority, duration, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.chat-meta.add-temp").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), Component.text((String)type.toString()), ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.WHITE)).append((Component)Component.text((char)'\''))).append(Message.formatColoredValue(value))).append((Component)Component.text((char)'\'')), Component.text((int)priority, (TextColor)NamedTextColor.AQUA), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(DurationFormatter.LONG.format((Duration)duration)), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args5<PermissionHolder, ChatMetaType, String, Integer, ContextSet> REMOVE_CHATMETA_SUCCESS = (holder, type, value, priority, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.chat-meta.remove").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), Component.text((String)type.toString()), ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.WHITE)).append((Component)Component.text((char)'\''))).append(Message.formatColoredValue(value))).append((Component)Component.text((char)'\'')), Component.text((int)priority, (TextColor)NamedTextColor.AQUA), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args4<PermissionHolder, ChatMetaType, Integer, ContextSet> BULK_REMOVE_CHATMETA_SUCCESS = (holder, type, priority, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.chat-meta.remove-bulk").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), Component.text((String)(type.toString() + "es")), Component.text((int)priority, (TextColor)NamedTextColor.AQUA), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args5<PermissionHolder, ChatMetaType, String, Integer, ContextSet> REMOVE_TEMP_CHATMETA_SUCCESS = (holder, type, value, priority, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.chat-meta.remove-temp").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), Component.text((String)type.toString()), ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.WHITE)).append((Component)Component.text((char)'\''))).append((Component)Component.text((String)value))).append((Component)Component.text((char)'\'')), Component.text((int)priority, (TextColor)NamedTextColor.AQUA), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args4<PermissionHolder, ChatMetaType, Integer, ContextSet> BULK_REMOVE_TEMP_CHATMETA_SUCCESS = (holder, type, priority, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.chat-meta.remove-temp-bulk").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), Component.text((String)(type.toString() + "es")), Component.text((int)priority, (TextColor)NamedTextColor.AQUA), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args4<PermissionHolder, String, String, ContextSet> ALREADY_HAS_META = (holder, key, value, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.meta.already-has").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.WHITE)).append((Component)Component.text((char)'\''))).append((Component)Component.text((String)key))).append((Component)Component.text((char)'\'')), ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.WHITE)).append((Component)Component.text((char)'\''))).append(Message.formatColoredValue(value))).append((Component)Component.text((char)'\'')), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args4<PermissionHolder, String, String, ContextSet> ALREADY_HAS_TEMP_META = (holder, key, value, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.meta.already-has-temp").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.WHITE)).append((Component)Component.text((char)'\''))).append((Component)Component.text((String)key))).append((Component)Component.text((char)'\'')), ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.WHITE)).append((Component)Component.text((char)'\''))).append(Message.formatColoredValue(value))).append((Component)Component.text((char)'\'')), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args3<PermissionHolder, String, ContextSet> DOESNT_HAVE_META = (holder, key, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.meta.doesnt-have").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.WHITE)).append((Component)Component.text((char)'\''))).append((Component)Component.text((String)key))).append((Component)Component.text((char)'\'')), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args3<PermissionHolder, String, ContextSet> DOESNT_HAVE_TEMP_META = (holder, key, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.meta.doesnt-have-temp").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.WHITE)).append((Component)Component.text((char)'\''))).append((Component)Component.text((String)key))).append((Component)Component.text((char)'\'')), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args4<String, String, PermissionHolder, ContextSet> SET_META_SUCCESS = (key, value, holder, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.meta.set").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.WHITE)).append((Component)Component.text((char)'\''))).append((Component)Component.text((String)key))).append((Component)Component.text((char)'\'')), ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.WHITE)).append((Component)Component.text((char)'\''))).append(Message.formatColoredValue(value))).append((Component)Component.text((char)'\'')), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args5<String, String, PermissionHolder, Duration, ContextSet> SET_META_TEMP_SUCCESS = (key, value, holder, duration, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.meta.set-temp").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.WHITE)).append((Component)Component.text((char)'\''))).append((Component)Component.text((String)key))).append((Component)Component.text((char)'\'')), ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.WHITE)).append((Component)Component.text((char)'\''))).append(Message.formatColoredValue(value))).append((Component)Component.text((char)'\'')), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(DurationFormatter.LONG.format((Duration)duration)), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args3<String, PermissionHolder, ContextSet> UNSET_META_SUCCESS = (key, holder, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.meta.unset").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.WHITE)).append((Component)Component.text((char)'\''))).append((Component)Component.text((String)key))).append((Component)Component.text((char)'\'')), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args3<String, PermissionHolder, ContextSet> UNSET_META_TEMP_SUCCESS = (key, holder, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.generic.meta.unset-temp").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.WHITE)).append((Component)Component.text((char)'\''))).append((Component)Component.text((String)key))).append((Component)Component.text((char)'\'')), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(holder.getFormattedDisplayName()), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args0 BULK_UPDATE_DISABLED = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.bulkupdate.disabled").color((TextColor)NamedTextColor.RED)).append((Component)FULL_STOP));
    public static final Args0 BULK_UPDATE_MUST_USE_CONSOLE = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.bulkupdate.must-use-console").color((TextColor)NamedTextColor.RED)).append((Component)FULL_STOP));
    public static final Args0 BULK_UPDATE_INVALID_DATA_TYPE = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.bulkupdate.invalid-data-type").color((TextColor)NamedTextColor.RED)).args((Component)Component.text((String)"'all', 'users' or 'groups'")).append((Component)FULL_STOP));
    public static final Args1<String> BULK_UPDATE_INVALID_CONSTRAINT = invalid -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.bulkupdate.invalid-constraint").color((TextColor)NamedTextColor.RED)).args((Component)Component.text((String)invalid, (TextColor)NamedTextColor.DARK_RED)).append((Component)FULL_STOP)).append((Component)Component.space())).append(Component.translatable().key("luckperms.command.bulkupdate.invalid-constraint-format").args(((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((char)'\''))).append((Component)Component.text((String)"<field> <comparison operator> <value>", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((char)'\''))).append((Component)FULL_STOP)));
    public static final Args1<String> BULK_UPDATE_INVALID_COMPARISON = invalid -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.bulkupdate.invalid-comparison").color((TextColor)NamedTextColor.RED)).args(((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((char)'\''))).append((Component)Component.text((String)invalid, (TextColor)NamedTextColor.DARK_RED))).append((Component)Component.text((char)'\''))).append((Component)FULL_STOP)).append((Component)Component.space())).append((ComponentBuilder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.bulkupdate.invalid-comparison-format").color((TextColor)NamedTextColor.WHITE)).args((Component)Component.text((String)"==  !=  ~~  ~!"))));
    public static final Args1<String> BULK_UPDATE_QUEUED = id -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.bulkupdate.queued").color((TextColor)NamedTextColor.GREEN)).append((Component)FULL_STOP)).append((Component)Component.space())).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)OPEN_BRACKET)).append((Component)Component.text((String)id, (TextColor)NamedTextColor.WHITE))).append((Component)CLOSE_BRACKET)));
    public static final Args2<String, String> BULK_UPDATE_CONFIRM = (label, id) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.bulkupdate.confirm").color((TextColor)NamedTextColor.GREEN)).args((Component)Component.text((String)("/" + label + " bulkupdate confirm " + id), (TextColor)NamedTextColor.AQUA)).append((Component)FULL_STOP));
    public static final Args1<String> BULK_UPDATE_UNKNOWN_ID = id -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.bulkupdate.unknown-id").color((TextColor)NamedTextColor.GREEN)).args((Component)Component.text((String)id, (TextColor)NamedTextColor.AQUA)).append((Component)FULL_STOP));
    public static final Args0 BULK_UPDATE_STARTING = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.bulkupdate.starting").color((TextColor)NamedTextColor.GREEN)).append((Component)FULL_STOP));
    public static final Args0 BULK_UPDATE_SUCCESS = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.bulkupdate.success").color((TextColor)NamedTextColor.AQUA)).append((Component)FULL_STOP));
    public static final Args3<Integer, Integer, Integer> BULK_UPDATE_STATISTICS = (nodes, users, groups) -> Message.joinNewline(new ComponentLike[]{Message.prefixed((ComponentLike)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.bulkupdate.success.statistics.nodes").color((TextColor)NamedTextColor.AQUA)).append((Component)Component.text((String)": "))).append((Component)Component.text((int)nodes, (TextColor)NamedTextColor.GREEN))), Message.prefixed((ComponentLike)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.bulkupdate.success.statistics.users").color((TextColor)NamedTextColor.AQUA)).append((Component)Component.text((String)": "))).append((Component)Component.text((int)users, (TextColor)NamedTextColor.GREEN))), Message.prefixed((ComponentLike)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.bulkupdate.success.statistics.groups").color((TextColor)NamedTextColor.AQUA)).append((Component)Component.text((String)": "))).append((Component)Component.text((int)groups, (TextColor)NamedTextColor.GREEN)))});
    public static final Args0 BULK_UPDATE_FAILURE = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.bulkupdate.failure").color((TextColor)NamedTextColor.RED)).append((Component)FULL_STOP));
    public static final Args0 TRANSLATIONS_SEARCHING = () -> Message.prefixed((ComponentLike)Component.translatable().key("luckperms.command.translations.searching").color((TextColor)NamedTextColor.GRAY));
    public static final Args0 TRANSLATIONS_SEARCHING_ERROR = () -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.RED)).append((Component)Component.translatable((String)"luckperms.command.translations.searching-error"))).append((Component)FULL_STOP)).append((Component)Component.space())).append((Component)Component.translatable((String)"luckperms.command.misc.check-console-for-errors"))).append((Component)FULL_STOP));
    public static final Args1<Collection<String>> INSTALLED_TRANSLATIONS = locales -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.translations.installed-translations").color((TextColor)NamedTextColor.GREEN)).append((Component)Component.text((char)':'))).append((Component)Component.space())).append(Message.formatStringList(locales)));
    public static final Args0 AVAILABLE_TRANSLATIONS_HEADER = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.translations.available-translations").color((TextColor)NamedTextColor.GREEN)).append((Component)Component.text((char)':')));
    public static final Args4<String, String, Integer, List<String>> AVAILABLE_TRANSLATIONS_ENTRY = (tag, name, percentComplete, contributors) -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)Component.text((char)'-'))).append((Component)Component.space())).append((Component)Component.text((String)tag, (TextColor)NamedTextColor.AQUA))).append((Component)Component.space())).append((Component)OPEN_BRACKET)).append((Component)Component.text((String)name, (TextColor)NamedTextColor.WHITE))).append((Component)CLOSE_BRACKET)).append((Component)Component.text((String)" - "))).append((Component)Component.translatable((String)"luckperms.command.translations.percent-translated", (ComponentLike[])new ComponentLike[]{Component.text((int)percentComplete, (TextColor)NamedTextColor.GREEN)}))).apply(builder -> {
        if (!contributors.isEmpty()) {
            builder.append((Component)Component.text((String)" - "));
            builder.append((Component)Component.translatable((String)"luckperms.command.translations.translations-by"));
            builder.append((Component)Component.space());
            builder.append(Message.formatStringList(contributors));
        }
    }));
    public static final Args1<String> TRANSLATIONS_DOWNLOAD_PROMPT = label -> Message.joinNewline(new ComponentLike[]{Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.translations.download-prompt").color((TextColor)NamedTextColor.AQUA)).args((Component)Component.text((String)("/" + label + " translations install"), (TextColor)NamedTextColor.GREEN)).append((Component)FULL_STOP)), Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.translations.download-override-warning").color((TextColor)NamedTextColor.GRAY)).append((Component)FULL_STOP))});
    public static final Args0 TRANSLATIONS_INSTALLING = () -> Message.prefixed((ComponentLike)Component.translatable().key("luckperms.command.translations.installing").color((TextColor)NamedTextColor.AQUA));
    public static final Args1<String> TRANSLATIONS_INSTALLING_SPECIFIC = name -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.translations.installing-specific").color((TextColor)NamedTextColor.GREEN)).args((Component)Component.text((String)name)));
    public static final Args0 TRANSLATIONS_INSTALL_COMPLETE = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.translations.install-complete").color((TextColor)NamedTextColor.AQUA)).append((Component)FULL_STOP));
    public static final Args1<String> TRANSLATIONS_DOWNLOAD_ERROR = name -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.RED)).append((Component)Component.translatable((String)"luckperms.command.translations.download-error", (ComponentLike[])new ComponentLike[]{Component.text((String)name, (TextColor)NamedTextColor.DARK_RED)}))).append((Component)FULL_STOP)).append((Component)Component.space())).append((Component)Component.translatable((String)"luckperms.command.misc.check-console-for-errors"))).append((Component)FULL_STOP));
    public static final Args4<String, String, Component, Boolean> USER_INFO_GENERAL = (username, uuid, uuidType, online) -> Message.joinNewline(new ComponentLike[]{Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append((Component)Component.text((char)'>', (Style)Style.style((TextDecoration)TextDecoration.BOLD)))).append((Component)Component.space())).append((Component)Component.translatable((String)"luckperms.command.user.info.title"))).append((Component)Component.text((String)": "))).append((Component)Component.text((String)username, (TextColor)NamedTextColor.WHITE))), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append((Component)Component.text((String)"- ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.translatable((String)"luckperms.command.user.info.uuid-key"))).append((Component)Component.text((String)": "))).append((Component)Component.text((String)uuid, (TextColor)NamedTextColor.WHITE))), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)Component.text((String)"    "))).append((Component)OPEN_BRACKET)).append((Component)Component.translatable((String)"luckperms.command.user.info.uuid-type-key"))).append((Component)Component.text((String)": "))).append(uuidType)).append((Component)CLOSE_BRACKET)), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append((Component)Component.text((String)"- ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.translatable((String)"luckperms.command.user.info.status-key"))).append((Component)Component.text((String)": "))).append((Component)(online != false ? Component.translatable((String)"luckperms.command.user.info.status.online", (TextColor)NamedTextColor.GREEN) : Component.translatable((String)"luckperms.command.user.info.status.offline", (TextColor)NamedTextColor.RED))))});
    public static final Args6<Boolean, ContextSet, String, String, String, Map<String, List<String>>> USER_INFO_CONTEXTUAL_DATA = (active, contexts, prefix, suffix, primaryGroup, meta) -> Message.joinNewline(new ComponentLike[]{Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((char)'-', (TextColor)NamedTextColor.WHITE))).append((Component)Component.space())).append((Component)Component.translatable((String)"luckperms.command.generic.contextual-data.title", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)": ", (TextColor)NamedTextColor.GREEN))).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)OPEN_BRACKET)).append((Component)Component.translatable((String)"luckperms.command.generic.contextual-data.mode.key"))).append((Component)Component.text((String)": "))).append((Component)(active != false ? Component.translatable((String)"luckperms.command.generic.contextual-data.mode.active-player", (TextColor)NamedTextColor.DARK_GREEN) : Component.translatable((String)"luckperms.command.generic.contextual-data.mode.server", (TextColor)NamedTextColor.DARK_GRAY)))).append((Component)CLOSE_BRACKET))), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append((Component)Component.text((String)"    "))).append((Component)Component.translatable((String)"luckperms.command.generic.contextual-data.contexts-key"))).append((Component)Component.text((String)": "))).append(Message.formatContextSetBracketed(contexts, (Component)Component.translatable((String)"luckperms.command.generic.contextual-data.null-result", (TextColor)NamedTextColor.AQUA)))), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append((Component)Component.text((String)"    "))).append((Component)Component.translatable((String)"luckperms.command.generic.contextual-data.prefix-key"))).append((Component)Component.text((String)": "))).apply(builder -> {
        if (prefix == null) {
            builder.append((Component)Component.translatable((String)"luckperms.command.generic.contextual-data.null-result", (TextColor)NamedTextColor.AQUA));
        } else {
            builder.append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.WHITE)).append((Component)Component.text((char)'\"'))).append(Message.formatColoredValue(prefix))).append((Component)Component.text((char)'\"')));
        }
    })), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append((Component)Component.text((String)"    "))).append((Component)Component.translatable((String)"luckperms.command.generic.contextual-data.suffix-key"))).append((Component)Component.text((String)": "))).apply(builder -> {
        if (suffix == null) {
            builder.append((Component)Component.translatable((String)"luckperms.command.generic.contextual-data.null-result", (TextColor)NamedTextColor.AQUA));
        } else {
            builder.append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.WHITE)).append((Component)Component.text((char)'\"'))).append(Message.formatColoredValue(suffix))).append((Component)Component.text((char)'\"')));
        }
    })), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append((Component)Component.text((String)"    "))).append((Component)Component.translatable((String)"luckperms.command.generic.contextual-data.primary-group-key"))).append((Component)Component.text((String)": "))).append((Component)Component.text((String)primaryGroup, (TextColor)NamedTextColor.WHITE))), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append((Component)Component.text((String)"    "))).append((Component)Component.translatable((String)"luckperms.command.generic.contextual-data.meta-key"))).append((Component)Component.text((String)": "))).apply(builder -> {
        if (meta.isEmpty()) {
            builder.append((Component)Component.translatable((String)"luckperms.command.generic.contextual-data.null-result", (TextColor)NamedTextColor.AQUA));
        } else {
            List entries = meta.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(value -> Maps.immutableEntry((Object)((String)entry.getKey()), (Object)value))).map(entry -> (TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_GRAY)).append((Component)OPEN_BRACKET)).append((Component)Component.text((String)((String)entry.getKey()), (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((char)'=', (TextColor)NamedTextColor.GRAY))).append(((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.WHITE)).append(Message.formatColoredValue((String)entry.getValue())))).append((Component)CLOSE_BRACKET)).build()).collect(Collectors.toList());
            builder.append(Component.join((JoinConfiguration)JoinConfiguration.separator((ComponentLike)Component.space()), entries));
        }
    }))});
    public static final Args0 INFO_PARENT_HEADER = () -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GREEN)).append((Component)Component.text((String)"- ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.translatable((String)"luckperms.command.generic.info.parent.title"))).append((Component)Component.text((char)':')));
    public static final Args0 INFO_TEMP_PARENT_HEADER = () -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GREEN)).append((Component)Component.text((String)"- ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.translatable((String)"luckperms.command.generic.info.parent.temporary-title"))).append((Component)Component.text((char)':')));
    public static final Args1<InheritanceNode> INFO_PARENT_NODE_ENTRY = node -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"    >", (TextColor)NamedTextColor.DARK_AQUA))).append((Component)Component.space())).append((Component)Component.text((String)node.getGroupName(), (TextColor)NamedTextColor.WHITE))).append((Component)Component.space())).append(Message.formatContextSetBracketed(node.getContexts(), (Component)Component.empty())));
    public static final Args1<InheritanceNode> INFO_PARENT_TEMPORARY_NODE_ENTRY = node -> Message.joinNewline(new ComponentLike[]{Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"    > ", (TextColor)NamedTextColor.DARK_AQUA))).append((Component)Component.text((String)node.getGroupName(), (TextColor)NamedTextColor.WHITE))).append((Component)Component.space())).append(Message.formatContextSetBracketed(node.getContexts(), (Component)Component.empty()))), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_GREEN)).append((Component)Component.text((String)"    -    "))).append((Component)Component.translatable((String)"luckperms.command.generic.info.expires-in"))).append((Component)Component.space())).append(DurationFormatter.LONG.format(node.getExpiryDuration())))});
    public static final Args0 USER_REMOVEGROUP_ERROR_PRIMARY = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.user.removegroup.error-primary").color((TextColor)NamedTextColor.GREEN)).append((Component)FULL_STOP));
    public static final Args2<User, Group> USER_PRIMARYGROUP_SUCCESS = (user, group) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.user.primarygroup.set").color((TextColor)NamedTextColor.GREEN)).args(new ComponentBuilder[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(user.getFormattedDisplayName()), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(group.getFormattedDisplayName())}).append((Component)FULL_STOP));
    public static final Args1<String> USER_PRIMARYGROUP_WARN_OPTION = option -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.user.primarygroup.warn-option").color((TextColor)NamedTextColor.GREEN)).args((Component)Component.text((String)option)).append((Component)FULL_STOP));
    public static final Args2<User, Group> USER_PRIMARYGROUP_ERROR_ALREADYHAS = (user, group) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.user.primarygroup.already-has").color((TextColor)NamedTextColor.GREEN)).args(new ComponentBuilder[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(user.getFormattedDisplayName()), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(group.getFormattedDisplayName())}).append((Component)FULL_STOP));
    public static final Args2<User, Group> USER_PRIMARYGROUP_ERROR_NOTMEMBER = (user, group) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.user.primarygroup.not-member").color((TextColor)NamedTextColor.GREEN)).args(new ComponentBuilder[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(user.getFormattedDisplayName()), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(group.getFormattedDisplayName())}).append((Component)FULL_STOP));
    public static final Args2<User, String> USER_TRACK_ERROR_NOT_CONTAIN_GROUP = (user, track) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.user.track.error-not-contain-group").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(user.getFormattedDisplayName()), Component.text((String)track, (TextColor)NamedTextColor.AQUA)}).append((Component)FULL_STOP));
    public static final Args0 USER_TRACK_ERROR_AMBIGUOUS_TRACK_SELECTION = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.user.track.unsure-which-track").color((TextColor)NamedTextColor.RED)).append((Component)FULL_STOP));
    public static final Args4<User, String, String, ContextSet> USER_TRACK_ADDED_TO_FIRST = (user, track, group, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.user.promote.added-to-first").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(user.getFormattedDisplayName()), Component.text((String)track, (TextColor)NamedTextColor.AQUA), Component.text((String)group, (TextColor)NamedTextColor.AQUA), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args2<User, String> USER_PROMOTE_NOT_ON_TRACK = (user, track) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.user.promote.not-on-track").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(user.getFormattedDisplayName()), Component.text((String)track, (TextColor)NamedTextColor.AQUA)}).append((Component)FULL_STOP));
    public static final Args5<User, String, String, String, ContextSet> USER_PROMOTE_SUCCESS = (user, track, from, to, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.user.promote.success").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(user.getFormattedDisplayName()), Component.text((String)track, (TextColor)NamedTextColor.AQUA), Component.text((String)from, (TextColor)NamedTextColor.AQUA), Component.text((String)to, (TextColor)NamedTextColor.AQUA), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args2<String, User> USER_PROMOTE_ERROR_ENDOFTRACK = (track, user) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.user.promote.end-of-track").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{Component.text((String)track, (TextColor)NamedTextColor.AQUA), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(user.getFormattedDisplayName())}).append((Component)FULL_STOP));
    public static final Args1<String> USER_PROMOTE_ERROR_MALFORMED = name -> Message.joinNewline(new ComponentLike[]{Message.prefixed((ComponentLike)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.user.promote.next-group-deleted").color((TextColor)NamedTextColor.GREEN)).args((Component)Component.text((String)name, (TextColor)NamedTextColor.AQUA)).append((Component)FULL_STOP)).append((Component)Component.space())).append((Component)Component.translatable((String)"luckperms.command.user.promote.unable-to-promote"))).append((Component)FULL_STOP)), Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.user.track.missing-group-advice").color((TextColor)NamedTextColor.GREEN)).append((Component)FULL_STOP))});
    public static final Args5<User, String, String, String, ContextSet> USER_DEMOTE_SUCCESS = (user, track, from, to, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.user.demote.success").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(user.getFormattedDisplayName()), Component.text((String)track, (TextColor)NamedTextColor.AQUA), Component.text((String)from, (TextColor)NamedTextColor.AQUA), Component.text((String)to, (TextColor)NamedTextColor.AQUA), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args3<String, User, String> USER_DEMOTE_ENDOFTRACK = (track, user, group) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.user.demote.end-of-track").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{Component.text((String)track, (TextColor)NamedTextColor.AQUA), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(user.getFormattedDisplayName()), Component.text((String)group, (TextColor)NamedTextColor.AQUA)}).append((Component)FULL_STOP));
    public static final Args2<String, User> USER_DEMOTE_ENDOFTRACK_NOT_REMOVED = (track, user) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.user.demote.end-of-track-not-removed").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{Component.text((String)track, (TextColor)NamedTextColor.AQUA), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(user.getFormattedDisplayName())}).append((Component)FULL_STOP));
    public static final Args1<String> USER_DEMOTE_ERROR_MALFORMED = name -> Message.joinNewline(new ComponentLike[]{Message.prefixed((ComponentLike)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.user.demote.previous-group-deleted").color((TextColor)NamedTextColor.GREEN)).args((Component)Component.text((String)name, (TextColor)NamedTextColor.AQUA)).append((Component)FULL_STOP)).append((Component)Component.space())).append((Component)Component.translatable((String)"luckperms.command.user.demote.unable-to-demote"))).append((Component)FULL_STOP)), Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.user.track.missing-group-advice").color((TextColor)NamedTextColor.GREEN)).append((Component)FULL_STOP))});
    public static final Args3<String, String, OptionalInt> GROUP_INFO_GENERAL = (name, displayName, weight) -> Message.joinNewline(new ComponentLike[]{Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append((Component)Component.text((char)'>', (Style)Style.style((TextDecoration)TextDecoration.BOLD)))).append((Component)Component.space())).append((Component)Component.translatable((String)"luckperms.command.group.info.title"))).append((Component)Component.text((String)": "))).append((Component)Component.text((String)name, (TextColor)NamedTextColor.WHITE))), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append((Component)Component.text((String)"- ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.translatable((String)"luckperms.command.group.info.display-name-key"))).append((Component)Component.text((String)": "))).append((Component)Component.text((String)displayName, (TextColor)NamedTextColor.WHITE))), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append((Component)Component.text((String)"- ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.translatable((String)"luckperms.command.group.info.weight-key"))).append((Component)Component.text((String)": "))).append((Component)(weight.isPresent() ? Component.text((int)weight.getAsInt(), (TextColor)NamedTextColor.WHITE) : Component.translatable((String)"luckperms.command.generic.contextual-data.null-result", (TextColor)NamedTextColor.WHITE))))});
    public static final Args3<String, String, Map<String, List<String>>> GROUP_INFO_CONTEXTUAL_DATA = (prefix, suffix, meta) -> Message.joinNewline(new ComponentLike[]{Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((char)'-', (TextColor)NamedTextColor.WHITE))).append((Component)Component.space())).append((Component)Component.translatable((String)"luckperms.command.generic.contextual-data.title", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)": ", (TextColor)NamedTextColor.GREEN))).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)OPEN_BRACKET)).append((Component)Component.translatable((String)"luckperms.command.generic.contextual-data.mode.key"))).append((Component)Component.text((String)": "))).append((Component)Component.translatable((String)"luckperms.command.generic.contextual-data.mode.server", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)CLOSE_BRACKET))), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append((Component)Component.text((String)"    "))).append((Component)Component.translatable((String)"luckperms.command.generic.contextual-data.prefix-key"))).append((Component)Component.text((String)": "))).apply(builder -> {
        if (prefix == null) {
            builder.append((Component)Component.translatable((String)"luckperms.command.generic.contextual-data.null-result", (TextColor)NamedTextColor.AQUA));
        } else {
            builder.append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.WHITE)).append((Component)Component.text((char)'\"'))).append(Message.formatColoredValue(prefix))).append((Component)Component.text((char)'\"')));
        }
    })), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append((Component)Component.text((String)"    "))).append((Component)Component.translatable((String)"luckperms.command.generic.contextual-data.suffix-key"))).append((Component)Component.text((String)": "))).apply(builder -> {
        if (suffix == null) {
            builder.append((Component)Component.translatable((String)"luckperms.command.generic.contextual-data.null-result", (TextColor)NamedTextColor.AQUA));
        } else {
            builder.append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.WHITE)).append((Component)Component.text((char)'\"'))).append(Message.formatColoredValue(suffix))).append((Component)Component.text((char)'\"')));
        }
    })), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).append((Component)Component.text((String)"    "))).append((Component)Component.translatable((String)"luckperms.command.generic.contextual-data.meta-key"))).append((Component)Component.text((String)": "))).apply(builder -> {
        if (meta.isEmpty()) {
            builder.append((Component)Component.translatable((String)"luckperms.command.generic.contextual-data.null-result", (TextColor)NamedTextColor.AQUA));
        } else {
            List entries = meta.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(value -> Maps.immutableEntry((Object)((String)entry.getKey()), (Object)value))).map(entry -> (TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_GRAY)).append((Component)OPEN_BRACKET)).append((Component)Component.text((String)((String)entry.getKey()), (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((char)'=', (TextColor)NamedTextColor.GRAY))).append(((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.WHITE)).append(Message.formatColoredValue((String)entry.getValue())))).append((Component)CLOSE_BRACKET)).build()).collect(Collectors.toList());
            builder.append(Component.join((JoinConfiguration)JoinConfiguration.separator((ComponentLike)Component.space()), entries));
        }
    }))});
    public static final Args2<Integer, Group> GROUP_SET_WEIGHT = (weight, group) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.group.setweight.set").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{Component.text((int)weight, (TextColor)NamedTextColor.AQUA), ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append(group.getFormattedDisplayName())}).append((Component)FULL_STOP));
    public static final Args1<String> GROUP_SET_DISPLAY_NAME_DOESNT_HAVE = group -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.group.setdisplayname.doesnt-have").color((TextColor)NamedTextColor.GREEN)).args((Component)Component.text((String)group, (TextColor)NamedTextColor.AQUA)).append((Component)FULL_STOP));
    public static final Args2<String, String> GROUP_SET_DISPLAY_NAME_ALREADY_HAS = (group, displayName) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.group.setdisplayname.already-has").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{Component.text((String)group, (TextColor)NamedTextColor.AQUA), Component.text((String)displayName, (TextColor)NamedTextColor.AQUA)}).append((Component)FULL_STOP));
    public static final Args2<String, String> GROUP_SET_DISPLAY_NAME_ALREADY_IN_USE = (displayName, group) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.group.setdisplayname.already-in-use").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{Component.text((String)displayName, (TextColor)NamedTextColor.AQUA), Component.text((String)group, (TextColor)NamedTextColor.AQUA)}).append((Component)FULL_STOP));
    public static final Args3<String, String, ContextSet> GROUP_SET_DISPLAY_NAME = (displayName, group, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.group.setdisplayname.set").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{Component.text((String)displayName, (TextColor)NamedTextColor.AQUA), Component.text((String)group, (TextColor)NamedTextColor.AQUA), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args2<String, ContextSet> GROUP_SET_DISPLAY_NAME_REMOVED = (group, context) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.group.setdisplayname.removed").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{Component.text((String)group, (TextColor)NamedTextColor.AQUA), Message.formatContextSet(context)}).append((Component)FULL_STOP));
    public static final Args2<String, Component> TRACK_INFO = (name, path) -> Message.joinNewline(new ComponentLike[]{Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append((Component)Component.text((char)'>', (Style)Style.style((TextDecoration)TextDecoration.BOLD)))).append((Component)Component.space())).append((Component)Component.translatable((String)"luckperms.command.track.info.showing-track"))).append((Component)Component.text((String)": "))).append((Component)Component.text((String)name, (TextColor)NamedTextColor.WHITE))), Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)Component.text((char)'-', (TextColor)NamedTextColor.WHITE))).append((Component)Component.space())).append((Component)Component.translatable((String)"luckperms.command.track.info.path-property"))).append((Component)Component.text((String)": "))).append(path))});
    public static final Args1<Collection<String>> TRACK_PATH = groups -> Message.prefixed((ComponentLike)Message.formatTrackPath(groups));
    public static final Args2<Collection<String>, String> TRACK_PATH_HIGHLIGHTED = (groups, highlighted) -> Message.prefixed((ComponentLike)Message.formatTrackPath(groups, highlighted));
    public static final Args4<Collection<String>, String, String, Boolean> TRACK_PATH_HIGHLIGHTED_PROGRESSION = (groups, highlightedFirst, highlightedSecond, reversed) -> Message.prefixed((ComponentLike)Message.formatTrackPath(groups, highlightedFirst, highlightedSecond, reversed));
    public static final Args1<String> TRACK_CLEAR = name -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.track.clear").color((TextColor)NamedTextColor.GREEN)).args((Component)Component.text((String)name, (TextColor)NamedTextColor.AQUA)).append((Component)FULL_STOP));
    public static final Args2<String, String> TRACK_APPEND_SUCCESS = (group, track) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.track.append.success").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{Component.text((String)group, (TextColor)NamedTextColor.AQUA), Component.text((String)track, (TextColor)NamedTextColor.AQUA)}).append((Component)FULL_STOP));
    public static final Args3<String, String, Integer> TRACK_INSERT_SUCCESS = (group, track, position) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.track.insert.success").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{Component.text((String)group, (TextColor)NamedTextColor.AQUA), Component.text((String)track, (TextColor)NamedTextColor.AQUA), Component.text((int)position, (TextColor)NamedTextColor.AQUA)}).append((Component)FULL_STOP));
    public static final Args1<String> TRACK_INSERT_ERROR_NUMBER = invalid -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.track.insert.error-number").color((TextColor)NamedTextColor.RED)).args((Component)Component.text((String)invalid)).append((Component)FULL_STOP));
    public static final Args1<Integer> TRACK_INSERT_ERROR_INVALID_POS = position -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.track.insert.error-invalid-pos").color((TextColor)NamedTextColor.RED)).args((Component)Component.text((int)position, (TextColor)NamedTextColor.DARK_RED)).append((Component)FULL_STOP)).append((Component)Component.space())).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)OPEN_BRACKET)).append((Component)Component.translatable((String)"luckperms.command.track.insert.error-invalid-pos-reason"))).append((Component)CLOSE_BRACKET)));
    public static final Args2<String, String> TRACK_REMOVE_SUCCESS = (group, track) -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.track.remove.success").color((TextColor)NamedTextColor.GREEN)).args(new ComponentLike[]{Component.text((String)group, (TextColor)NamedTextColor.AQUA), Component.text((String)track, (TextColor)NamedTextColor.AQUA)}).append((Component)FULL_STOP));
    public static final Args0 LOG_LOAD_ERROR = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.log.load-error").color((TextColor)NamedTextColor.RED)).append((Component)FULL_STOP));
    public static final Args1<Integer> LOG_INVALID_PAGE_RANGE = maxPage -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.RED)).append((Component)Component.translatable((String)"luckperms.command.log.invalid-page"))).append((Component)FULL_STOP)).append((Component)Component.space())).append((ComponentBuilder)Component.translatable().key("luckperms.command.log.invalid-page-range").args(new ComponentLike[]{Component.text((int)1, (TextColor)NamedTextColor.DARK_RED), Component.text((int)maxPage, (TextColor)NamedTextColor.DARK_RED)}))).append((Component)FULL_STOP));
    public static final Args0 LOG_NO_ENTRIES = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.log.empty").color((TextColor)NamedTextColor.AQUA)).append((Component)FULL_STOP));
    public static final Args2<Integer, LoggedAction> LOG_ENTRY = (pos, action) -> Message.joinNewline(new ComponentLike[]{Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)("#" + pos), (TextColor)NamedTextColor.AQUA))).append((Component)Component.space())).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_GRAY)).append((Component)OPEN_BRACKET)).append(((TranslatableComponent.Builder)Component.translatable().color((TextColor)NamedTextColor.GRAY)).key("luckperms.duration.since").args(DurationFormatter.CONCISE_LOW_ACCURACY.format(action.getDurationSince())).hoverEvent((HoverEventSource)HoverEvent.showText((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.translatable((String)"luckperms.duration.date", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)": ", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)DATE_FORMAT.format(action.getTimestamp()), (TextColor)NamedTextColor.AQUA)))))).append((Component)CLOSE_BRACKET))).append((Component)Component.space())).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_GRAY)).append((Component)OPEN_BRACKET)).append((Component)Component.text((String)action.getSourceFriendlyString(), (TextColor)NamedTextColor.YELLOW))).append((Component)CLOSE_BRACKET))).append((Component)Component.space())).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_GRAY)).append((Component)Component.text((char)'['))).append((Component)Component.text((char)LoggedAction.getTypeCharacter(action.getTarget().getType()), (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((char)']')))).append((Component)Component.space())).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_GRAY)).append((Component)OPEN_BRACKET)).append((Component)Component.text((String)action.getTargetFriendlyString(), (TextColor)NamedTextColor.AQUA))).append((Component)CLOSE_BRACKET))), Message.prefixed((ComponentLike)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"> ", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)action.getDescription(), (TextColor)NamedTextColor.WHITE)))});
    public static final Args0 LOG_NOTIFY_CONSOLE = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.log.notify.error-console").color((TextColor)NamedTextColor.RED)).append((Component)FULL_STOP));
    public static final Args0 LOG_NOTIFY_TOGGLE_ON = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.log.notify.changed-state").color((TextColor)NamedTextColor.AQUA)).args((Component)Component.translatable((String)"luckperms.command.log.notify.enabled-term", (TextColor)NamedTextColor.GREEN)).append((Component)FULL_STOP));
    public static final Args0 LOG_NOTIFY_TOGGLE_OFF = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.log.notify.changed-state").color((TextColor)NamedTextColor.AQUA)).args((Component)Component.translatable((String)"luckperms.command.log.notify.disabled-term", (TextColor)NamedTextColor.RED)).append((Component)FULL_STOP));
    public static final Args0 LOG_NOTIFY_ALREADY_ON = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.log.notify.already-on").color((TextColor)NamedTextColor.RED)).append((Component)FULL_STOP));
    public static final Args0 LOG_NOTIFY_ALREADY_OFF = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.log.notify.already-off").color((TextColor)NamedTextColor.RED)).append((Component)FULL_STOP));
    public static final Args0 LOG_NOTIFY_UNKNOWN = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.log.notify.invalid-state").color((TextColor)NamedTextColor.RED)).args(new ComponentLike[]{Component.text((String)"\"on\""), Component.text((String)"\"off\"")}).append((Component)FULL_STOP));
    public static final Args3<String, Integer, Integer> LOG_SEARCH_HEADER = (query, page, totalPages) -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GREEN)).append((ComponentBuilder)Component.translatable().key("luckperms.command.log.show.search").args((Component)Component.text((String)query, (TextColor)NamedTextColor.AQUA)))).append((Component)Component.text((String)"  "))).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)OPEN_BRACKET)).append((ComponentBuilder)Component.translatable().key("luckperms.command.misc.page").args(new ComponentLike[]{Component.text((int)page, (TextColor)NamedTextColor.WHITE), Component.text((int)totalPages, (TextColor)NamedTextColor.WHITE)}))).append((Component)CLOSE_BRACKET)));
    public static final Args2<Integer, Integer> LOG_RECENT_HEADER = (page, totalPages) -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GREEN)).append((Component)Component.translatable((String)"luckperms.command.log.show.recent"))).append((Component)Component.text((String)"  "))).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)OPEN_BRACKET)).append((ComponentBuilder)Component.translatable().key("luckperms.command.misc.page").args(new ComponentLike[]{Component.text((int)page, (TextColor)NamedTextColor.WHITE), Component.text((int)totalPages, (TextColor)NamedTextColor.WHITE)}))).append((Component)CLOSE_BRACKET)));
    public static final Args3<String, Integer, Integer> LOG_RECENT_BY_HEADER = (name, page, totalPages) -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GREEN)).append((ComponentBuilder)Component.translatable().key("luckperms.command.log.show.by").args((Component)Component.text((String)name, (TextColor)NamedTextColor.AQUA)))).append((Component)Component.text((String)"  "))).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)OPEN_BRACKET)).append((ComponentBuilder)Component.translatable().key("luckperms.command.misc.page").args(new ComponentLike[]{Component.text((int)page, (TextColor)NamedTextColor.WHITE), Component.text((int)totalPages, (TextColor)NamedTextColor.WHITE)}))).append((Component)CLOSE_BRACKET)));
    public static final Args3<String, Integer, Integer> LOG_HISTORY_USER_HEADER = (name, page, totalPages) -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GREEN)).append((ComponentBuilder)Component.translatable().key("luckperms.command.log.show.history").args(new ComponentLike[]{Component.text((String)"user"), Component.text((String)name, (TextColor)NamedTextColor.AQUA)}))).append((Component)Component.text((String)"  "))).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)OPEN_BRACKET)).append((ComponentBuilder)Component.translatable().key("luckperms.command.misc.page").args(new ComponentLike[]{Component.text((int)page, (TextColor)NamedTextColor.WHITE), Component.text((int)totalPages, (TextColor)NamedTextColor.WHITE)}))).append((Component)CLOSE_BRACKET)));
    public static final Args3<String, Integer, Integer> LOG_HISTORY_GROUP_HEADER = (name, page, totalPages) -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GREEN)).append((ComponentBuilder)Component.translatable().key("luckperms.command.log.show.history").args(new ComponentLike[]{Component.text((String)"group"), Component.text((String)name, (TextColor)NamedTextColor.AQUA)}))).append((Component)Component.text((String)"  "))).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)OPEN_BRACKET)).append((ComponentBuilder)Component.translatable().key("luckperms.command.misc.page").args(new ComponentLike[]{Component.text((int)page, (TextColor)NamedTextColor.WHITE), Component.text((int)totalPages, (TextColor)NamedTextColor.WHITE)}))).append((Component)CLOSE_BRACKET)));
    public static final Args3<String, Integer, Integer> LOG_HISTORY_TRACK_HEADER = (name, page, totalPages) -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GREEN)).append((ComponentBuilder)Component.translatable().key("luckperms.command.log.show.history").args(new ComponentLike[]{Component.text((String)"track"), Component.text((String)name, (TextColor)NamedTextColor.AQUA)}))).append((Component)Component.text((String)"  "))).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)OPEN_BRACKET)).append((ComponentBuilder)Component.translatable().key("luckperms.command.misc.page").args(new ComponentLike[]{Component.text((int)page, (TextColor)NamedTextColor.WHITE), Component.text((int)totalPages, (TextColor)NamedTextColor.WHITE)}))).append((Component)CLOSE_BRACKET)));
    public static final Args0 IMPORT_ALREADY_RUNNING = () -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.RED)).append((Component)Component.translatable((String)"luckperms.command.import.already-running"))).append((Component)FULL_STOP)).append((Component)Component.space())).append((Component)Component.translatable((String)"luckperms.command.misc.wait-to-finish"))).append((Component)FULL_STOP));
    public static final Args0 EXPORT_ALREADY_RUNNING = () -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.RED)).append((Component)Component.translatable((String)"luckperms.command.export.already-running"))).append((Component)FULL_STOP)).append((Component)Component.space())).append((Component)Component.translatable((String)"luckperms.command.misc.wait-to-finish"))).append((Component)FULL_STOP));
    public static final Args1<String> FILE_NOT_WITHIN_DIRECTORY = file -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.RED)).append((Component)Component.translatable((String)"luckperms.command.import.error-term"))).append((Component)Component.text((String)": "))).append((Component)Component.translatable((String)"luckperms.command.misc.file-must-be-in-data", (ComponentLike[])new ComponentLike[]{Component.text((String)file, (TextColor)NamedTextColor.DARK_RED)}))).append((Component)FULL_STOP));
    public static final Args1<String> EXPORT_FILE_ALREADY_EXISTS = file -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.RED)).append((Component)Component.translatable((String)"luckperms.command.export.error-term"))).append((Component)Component.text((String)": "))).append((Component)Component.translatable((String)"luckperms.command.export.file.already-exists", (ComponentLike[])new ComponentLike[]{Component.text((String)file, (TextColor)NamedTextColor.DARK_RED)}))).append((Component)FULL_STOP));
    public static final Args1<String> EXPORT_FILE_NOT_WRITABLE = file -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.RED)).append((Component)Component.translatable((String)"luckperms.command.export.error-term"))).append((Component)Component.text((String)": "))).append((Component)Component.translatable((String)"luckperms.command.export.file.not-writable", (ComponentLike[])new ComponentLike[]{Component.text((String)file, (TextColor)NamedTextColor.DARK_RED)}))).append((Component)FULL_STOP));
    public static final Args0 EXPORT_FILE_FAILURE = () -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.export.file-unexpected-error-writing").color((TextColor)NamedTextColor.RED)).append((Component)FULL_STOP));
    public static final Args1<String> EXPORT_FILE_SUCCESS = file -> Message.prefixed((ComponentLike)((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.export.file.success").color((TextColor)NamedTextColor.GREEN)).args((Component)Component.text((String)file, (TextColor)NamedTextColor.AQUA)).append((Component)FULL_STOP));
    public static final Args2<String, String> EXPORT_WEB_SUCCESS = (pasteId, label) -> Message.joinNewline(new ComponentLike[]{Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GREEN)).append((Component)Component.translatable((String)"luckperms.command.export.web.export-code"))).append((Component)Component.text((String)": "))).append((Component)Component.text((String)pasteId, (TextColor)NamedTextColor.GRAY))), ((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.export.web.import-command-description").color((TextColor)NamedTextColor.GRAY)).append((Component)Component.text((String)":")), Component.text((String)("/" + label + " import " + pasteId + " --upload"), (TextColor)NamedTextColor.GREEN)});
    public static final Args1<String> IMPORT_FILE_DOESNT_EXIST = file -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.RED)).append((Component)Component.translatable((String)"luckperms.command.import.error-term"))).append((Component)Component.text((String)": "))).append((Component)Component.translatable((String)"luckperms.command.import.file.doesnt-exist", (ComponentLike[])new ComponentLike[]{Component.text((String)file, (TextColor)NamedTextColor.DARK_RED)}))).append((Component)FULL_STOP));
    public static final Args1<String> IMPORT_FILE_NOT_READABLE = file -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.RED)).append((Component)Component.translatable((String)"luckperms.command.import.error-term"))).append((Component)Component.text((String)": "))).append((Component)Component.translatable((String)"luckperms.command.import.file.not-readable", (ComponentLike[])new ComponentLike[]{Component.text((String)file, (TextColor)NamedTextColor.DARK_RED)}))).append((Component)FULL_STOP));
    public static final Args0 IMPORT_FILE_READ_FAILURE = () -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.RED)).append((Component)Component.translatable((String)"luckperms.command.import.file.unexpected-error-reading"))).append((Component)FULL_STOP)).append((Component)Component.space())).append(((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)OPEN_BRACKET)).append((Component)Component.translatable((String)"luckperms.command.import.file.correct-format"))).append((Component)CLOSE_BRACKET)));
    public static final Args1<String> IMPORT_WEB_INVALID_CODE = code -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.RED)).append((Component)Component.translatable((String)"luckperms.command.misc.invalid-code"))).append((Component)FULL_STOP)).append((Component)Component.space())).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)OPEN_BRACKET)).append((Component)Component.text((String)code))).append((Component)CLOSE_BRACKET)));
    public static final Args2<Integer, String> HTTP_REQUEST_FAILURE = (code, message) -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.RED)).append((Component)Component.translatable((String)"luckperms.command.misc.bytebin-unable-to-communicate"))).append((Component)FULL_STOP)).append((Component)Component.space())).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)OPEN_BRACKET)).append((Component)Component.translatable((String)"luckperms.command.misc.response-code-key"))).append((Component)Component.space())).append((Component)Component.text((int)code))).append((Component)Component.text((String)", "))).append((Component)Component.translatable((String)"luckperms.command.misc.error-message-key"))).append((Component)Component.text((String)"='"))).append((Component)Component.text((String)message))).append((Component)Component.text((String)"'"))).append((Component)CLOSE_BRACKET)));
    public static final Args0 HTTP_UNKNOWN_FAILURE = () -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.RED)).append((Component)Component.translatable((String)"luckperms.command.misc.bytebin-unable-to-communicate"))).append((Component)FULL_STOP)).append((Component)Component.space())).append((Component)Component.translatable((String)"luckperms.command.misc.check-console-for-errors"))).append((Component)FULL_STOP));
    public static final Args1<String> IMPORT_UNABLE_TO_READ = code -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.RED)).append((Component)Component.translatable((String)"luckperms.command.import.web.unable-to-read"))).append((Component)FULL_STOP)).append((Component)Component.space())).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)OPEN_BRACKET)).append((Component)Component.text((String)code))).append((Component)CLOSE_BRACKET)));
    public static final Args3<Integer, Integer, Integer> IMPORT_PROGRESS = (percent, processed, total) -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append((Component)OPEN_BRACKET)).append((Component)Component.translatable((String)"luckperms.command.import.term"))).append((Component)CLOSE_BRACKET))).append((Component)Component.text((String)" -> ", (TextColor)NamedTextColor.AQUA))).append((Component)Component.translatable((String)"luckperms.command.import.progress.percent", (TextColor)NamedTextColor.WHITE, (ComponentLike[])new ComponentLike[]{Component.text((int)percent)}))).append((Component)Component.text((String)" - ", (TextColor)NamedTextColor.GRAY))).append(((TranslatableComponent.Builder)Component.translatable().key("luckperms.command.import.progress.operations").color((TextColor)NamedTextColor.WHITE)).args(new ComponentLike[]{Component.text((int)processed, (TextColor)NamedTextColor.AQUA), Component.text((int)total, (TextColor)NamedTextColor.AQUA)}).append((Component)FULL_STOP)));
    public static final Args0 IMPORT_START = () -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.WHITE)).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append((Component)OPEN_BRACKET)).append((Component)Component.translatable((String)"luckperms.command.import.term"))).append((Component)CLOSE_BRACKET))).append((Component)Component.text((String)" -> ", (TextColor)NamedTextColor.AQUA))).append((Component)Component.translatable((String)"luckperms.command.import.starting"))).append((Component)FULL_STOP));
    public static final Args1<String> IMPORT_INFO = msg -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.WHITE)).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append((Component)OPEN_BRACKET)).append((Component)Component.translatable((String)"luckperms.command.import.term"))).append((Component)CLOSE_BRACKET))).append((Component)Component.text((String)" -> ", (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)msg))).append((Component)FULL_STOP));
    public static final Args1<Double> IMPORT_END_COMPLETE = seconds -> Message.prefixed((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.AQUA)).append((Component)OPEN_BRACKET)).append((Component)Component.translatable((String)"luckperms.command.import.term"))).append((Component)CLOSE_BRACKET))).append((Component)Component.space())).append((Component)Component.translatable((String)"luckperms.command.import.completed", (TextColor)NamedTextColor.GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)" - "))).append((Component)Component.translatable((String)"luckperms.command.import.duration", (ComponentLike[])new ComponentLike[]{Component.text((double)seconds, (TextColor)NamedTextColor.AQUA)}))).append((Component)FULL_STOP));

    public static TextComponent prefixed(ComponentLike component) {
        return (TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(PREFIX_COMPONENT)).append((Component)Component.space())).append(component)).build();
    }

    public static Component formatColoredValue(String value) {
        boolean containsLegacyFormattingCharacter = value.indexOf(38) != -1 || value.indexOf(167) != -1;
        HoverEvent hover = HoverEvent.showText((Component)Component.text((String)value, (TextColor)NamedTextColor.WHITE));
        if (containsLegacyFormattingCharacter) {
            return ((TextComponent.Builder)((TextComponent.Builder)LegacyComponentSerializer.legacyAmpersand().deserialize(value).toBuilder()).hoverEvent((HoverEventSource)hover)).build();
        }
        return MiniMessage.miniMessage().deserialize((Object)value).hoverEvent((HoverEventSource)hover);
    }

    public static Component formatContextBracketed(String key, String value) {
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_GRAY)).append((Component)OPEN_BRACKET)).append((Component)Component.text((String)key, (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((char)'=', (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)value, (TextColor)NamedTextColor.WHITE))).append((Component)CLOSE_BRACKET)).build();
    }

    public static Component formatContextBracketed(Context context) {
        return Message.formatContextBracketed(context.getKey(), context.getValue());
    }

    public static Component formatContext(String key, String value) {
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(key).color((TextColor)NamedTextColor.DARK_AQUA)).append((Component)Component.text((char)'='))).append((Component)Component.text((String)value, (TextColor)NamedTextColor.AQUA))).build();
    }

    public static Component formatContext(Context context) {
        return Message.formatContext(context.getKey(), context.getValue());
    }

    public static Component formatContextSet(ContextSet set) {
        Iterator<Context> it = set.iterator();
        if (!it.hasNext()) {
            return Component.text((String)"global", (TextColor)NamedTextColor.YELLOW);
        }
        TextComponent.Builder builder = (TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GREEN);
        builder.append(Message.formatContext(it.next()));
        while (it.hasNext()) {
            builder.append((Component)Component.text((String)", "));
            builder.append(Message.formatContext(it.next()));
        }
        return builder.build();
    }

    public static Component formatContextSetBracketed(ContextSet set, Component ifEmpty) {
        Iterator<Context> it = set.iterator();
        if (!it.hasNext()) {
            return ifEmpty;
        }
        TextComponent.Builder builder = Component.text();
        builder.append(Message.formatContextBracketed(it.next()));
        while (it.hasNext()) {
            builder.append((Component)Component.text((String)" "));
            builder.append(Message.formatContextBracketed(it.next()));
        }
        return builder.build();
    }

    public static Component formatTrackPath(Collection<String> groups) {
        Iterator<String> it = groups.iterator();
        if (!it.hasNext()) {
            return Component.translatable((String)"luckperms.command.track.path.empty", (TextColor)NamedTextColor.GOLD);
        }
        TextComponent.Builder builder = ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).content(it.next());
        while (it.hasNext()) {
            builder.append((Component)Component.text((String)" ---> ", (TextColor)NamedTextColor.AQUA));
            builder.append((Component)Component.text((String)it.next()));
        }
        return builder.build();
    }

    public static Component formatTrackPath(Collection<String> groups, String highlighed) {
        if (groups.isEmpty()) {
            return Component.translatable((String)"luckperms.command.track.path.empty", (TextColor)NamedTextColor.AQUA);
        }
        TextComponent.Builder builder = (TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA);
        boolean first = true;
        for (String group : groups) {
            if (first) {
                first = false;
            } else {
                builder.append((Component)Component.text((String)" ---> ", (TextColor)NamedTextColor.GRAY));
            }
            builder.append((Component)(group.equalsIgnoreCase(highlighed) ? Component.text((String)group, (TextColor)NamedTextColor.AQUA) : Component.text((String)group)));
        }
        return builder.build();
    }

    public static Component formatTrackPath(Collection<String> groups, String highlightedFirst, String highlightedSecond, boolean reversed) {
        if (groups.isEmpty()) {
            return Component.translatable((String)"luckperms.command.track.path.empty", (TextColor)NamedTextColor.GOLD);
        }
        TextComponent.Builder builder = (TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA);
        boolean first = true;
        boolean highlight = false;
        for (String group : groups) {
            if (first) {
                first = false;
            } else {
                builder.append((Component)Component.text((String)(reversed ? " <--- " : " ---> "), (TextColor)(highlight ? NamedTextColor.DARK_RED : NamedTextColor.GRAY)));
            }
            if (group.equalsIgnoreCase(highlightedFirst)) {
                builder.append((Component)Component.text((String)group, (TextColor)NamedTextColor.AQUA));
                highlight = true;
                continue;
            }
            if (group.equalsIgnoreCase(highlightedSecond)) {
                builder.append((Component)Component.text((String)group, (TextColor)NamedTextColor.AQUA));
                highlight = false;
                continue;
            }
            builder.append((Component)Component.text((String)group));
        }
        return builder.build();
    }

    public static Component formatStringList(Collection<String> strings) {
        Iterator<String> it = strings.iterator();
        if (!it.hasNext()) {
            return Component.translatable((String)"luckperms.command.misc.none", (TextColor)NamedTextColor.AQUA);
        }
        TextComponent.Builder builder = ((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.DARK_AQUA)).content(it.next());
        while (it.hasNext()) {
            builder.append((Component)Component.text((String)", ", (TextColor)NamedTextColor.GRAY));
            builder.append((Component)Component.text((String)it.next()));
        }
        return builder.build();
    }

    public static Component formatBoolean(boolean bool) {
        return bool ? Component.text((String)"true", (TextColor)NamedTextColor.GREEN) : Component.text((String)"false", (TextColor)NamedTextColor.RED);
    }

    public static Component formatTristate(Tristate tristate) {
        switch (tristate) {
            case TRUE: {
                return Component.text((String)"true", (TextColor)NamedTextColor.GREEN);
            }
            case FALSE: {
                return Component.text((String)"false", (TextColor)NamedTextColor.RED);
            }
        }
        return Component.text((String)"undefined", (TextColor)NamedTextColor.GRAY);
    }

    public static Component joinNewline(ComponentLike ... components) {
        return Component.join((JoinConfiguration)JoinConfiguration.newlines(), (ComponentLike[])components);
    }

    public static interface Args1<A0> {
        public Component build(A0 var1);

        default public void send(Sender sender, A0 arg0) {
            sender.sendMessage(this.build(arg0));
        }
    }

    public static interface Args0 {
        public Component build();

        default public void send(Sender sender) {
            sender.sendMessage(this.build());
        }
    }

    public static interface Args2<A0, A1> {
        public Component build(A0 var1, A1 var2);

        default public void send(Sender sender, A0 arg0, A1 arg1) {
            sender.sendMessage(this.build(arg0, arg1));
        }
    }

    public static interface Args3<A0, A1, A2> {
        public Component build(A0 var1, A1 var2, A2 var3);

        default public void send(Sender sender, A0 arg0, A1 arg1, A2 arg2) {
            sender.sendMessage(this.build(arg0, arg1, arg2));
        }
    }

    public static interface Args6<A0, A1, A2, A3, A4, A5> {
        public Component build(A0 var1, A1 var2, A2 var3, A3 var4, A4 var5, A5 var6);

        default public void send(Sender sender, A0 arg0, A1 arg1, A2 arg2, A3 arg3, A4 arg4, A5 arg5) {
            sender.sendMessage(this.build(arg0, arg1, arg2, arg3, arg4, arg5));
        }
    }

    public static interface Args5<A0, A1, A2, A3, A4> {
        public Component build(A0 var1, A1 var2, A2 var3, A3 var4, A4 var5);

        default public void send(Sender sender, A0 arg0, A1 arg1, A2 arg2, A3 arg3, A4 arg4) {
            sender.sendMessage(this.build(arg0, arg1, arg2, arg3, arg4));
        }
    }

    public static interface Args4<A0, A1, A2, A3> {
        public Component build(A0 var1, A1 var2, A2 var3, A3 var4);

        default public void send(Sender sender, A0 arg0, A1 arg1, A2 arg2, A3 arg3) {
            sender.sendMessage(this.build(arg0, arg1, arg2, arg3));
        }
    }
}

