/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.dependencies;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import me.lucko.luckperms.common.dependencies.Dependency;
import me.lucko.luckperms.common.dependencies.DependencyDownloadException;
import me.lucko.luckperms.common.dependencies.DependencyManager;
import me.lucko.luckperms.common.dependencies.DependencyRegistry;
import me.lucko.luckperms.common.dependencies.DependencyRepository;
import me.lucko.luckperms.common.dependencies.classloader.IsolatedClassLoader;
import me.lucko.luckperms.common.dependencies.relocation.Relocation;
import me.lucko.luckperms.common.dependencies.relocation.RelocationHandler;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.plugin.classpath.ClassPathAppender;
import me.lucko.luckperms.common.storage.StorageType;
import me.lucko.luckperms.common.util.MoreFiles;
import net.luckperms.api.platform.Platform;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class DependencyManagerImpl
implements DependencyManager {
    private final DependencyRegistry registry;
    private final Path cacheDirectory;
    private final ClassPathAppender classPathAppender;
    private final Executor loadingExecutor;
    private final EnumMap<Dependency, Path> loaded = new EnumMap(Dependency.class);
    private final Map<ImmutableSet<Dependency>, IsolatedClassLoader> loaders = new HashMap<ImmutableSet<Dependency>, IsolatedClassLoader>();
    private @MonotonicNonNull RelocationHandler relocationHandler = null;

    public DependencyManagerImpl(LuckPermsPlugin plugin) {
        this.registry = new DependencyRegistry(plugin.getBootstrap().getType());
        this.cacheDirectory = DependencyManagerImpl.setupCacheDirectory(plugin);
        this.classPathAppender = plugin.getBootstrap().getClassPathAppender();
        this.loadingExecutor = plugin.getBootstrap().getScheduler().async();
    }

    public DependencyManagerImpl(Path cacheDirectory, Executor executor) {
        this.registry = new DependencyRegistry(Platform.Type.STANDALONE);
        this.cacheDirectory = cacheDirectory;
        this.classPathAppender = null;
        this.loadingExecutor = executor;
    }

    private synchronized RelocationHandler getRelocationHandler() {
        if (this.relocationHandler == null) {
            this.relocationHandler = new RelocationHandler(this);
        }
        return this.relocationHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassLoader obtainClassLoaderWith(Set<Dependency> dependencies) {
        ImmutableSet set = ImmutableSet.copyOf(dependencies);
        for (Dependency dependency : dependencies) {
            if (this.loaded.containsKey((Object)dependency)) continue;
            throw new IllegalStateException("Dependency " + (Object)((Object)dependency) + " is not loaded.");
        }
        Map<ImmutableSet<Dependency>, IsolatedClassLoader> map = this.loaders;
        synchronized (map) {
            IsolatedClassLoader classLoader = this.loaders.get(set);
            if (classLoader != null) {
                return classLoader;
            }
            URL[] urls = (URL[])set.stream().map(this.loaded::get).map(file -> {
                try {
                    return file.toUri().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }).toArray(URL[]::new);
            classLoader = new IsolatedClassLoader(urls);
            this.loaders.put((ImmutableSet<Dependency>)set, classLoader);
            return classLoader;
        }
    }

    @Override
    public void loadStorageDependencies(Set<StorageType> storageTypes, boolean redis, boolean rabbitmq, boolean nats) {
        this.loadDependencies(this.registry.resolveStorageDependencies(storageTypes, redis, rabbitmq, nats));
    }

    @Override
    public void loadDependencies(Set<Dependency> dependencies) {
        CountDownLatch latch = new CountDownLatch(dependencies.size());
        for (Dependency dependency : dependencies) {
            if (this.loaded.containsKey((Object)dependency)) {
                latch.countDown();
                continue;
            }
            this.loadingExecutor.execute(() -> {
                try {
                    this.loadDependency(dependency);
                }
                catch (Throwable e) {
                    new RuntimeException("Unable to load dependency " + dependency.name(), e).printStackTrace();
                }
                finally {
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void loadDependency(Dependency dependency) throws Exception {
        if (this.loaded.containsKey((Object)dependency)) {
            return;
        }
        Path file = this.remapDependency(dependency, this.downloadDependency(dependency));
        this.loaded.put(dependency, file);
        if (this.classPathAppender != null && this.registry.shouldAutoLoad(dependency)) {
            this.classPathAppender.addJarToClasspath(file);
        }
    }

    private Path downloadDependency(Dependency dependency) throws DependencyDownloadException {
        Path file = this.cacheDirectory.resolve(dependency.getFileName(null));
        if (Files.exists(file, new LinkOption[0])) {
            return file;
        }
        DependencyDownloadException lastError = null;
        for (DependencyRepository repo : DependencyRepository.values()) {
            try {
                repo.download(dependency, file);
                return file;
            }
            catch (DependencyDownloadException e) {
                lastError = e;
            }
        }
        throw (DependencyDownloadException)Objects.requireNonNull(lastError);
    }

    private Path remapDependency(Dependency dependency, Path normalFile) throws Exception {
        ArrayList<Relocation> rules = new ArrayList<Relocation>(dependency.getRelocations());
        this.registry.applyRelocationSettings(dependency, rules);
        if (rules.isEmpty()) {
            return normalFile;
        }
        Path remappedFile = this.cacheDirectory.resolve(dependency.getFileName(DependencyRegistry.isGsonRelocated() ? "remapped-legacy" : "remapped"));
        if (Files.exists(remappedFile, new LinkOption[0])) {
            return remappedFile;
        }
        this.getRelocationHandler().remap(normalFile, remappedFile, rules);
        return remappedFile;
    }

    private static Path setupCacheDirectory(LuckPermsPlugin plugin) {
        Path cacheDirectory = plugin.getBootstrap().getDataDirectory().resolve("libs");
        try {
            MoreFiles.createDirectoriesIfNotExists(cacheDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create libs directory", e);
        }
        Path oldCacheDirectory = plugin.getBootstrap().getDataDirectory().resolve("lib");
        if (Files.exists(oldCacheDirectory, new LinkOption[0])) {
            try {
                MoreFiles.deleteDirectory(oldCacheDirectory);
            }
            catch (IOException e) {
                plugin.getLogger().warn("Unable to delete lib directory", e);
            }
        }
        return cacheDirectory;
    }

    @Override
    public void close() {
        Throwable firstEx = null;
        for (IsolatedClassLoader loader : this.loaders.values()) {
            try {
                loader.close();
            }
            catch (IOException ex) {
                if (firstEx == null) {
                    firstEx = ex;
                    continue;
                }
                firstEx.addSuppressed(ex);
            }
        }
        if (firstEx != null) {
            firstEx.printStackTrace();
        }
    }
}

