/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.context.comparator;

import java.util.Arrays;
import java.util.Comparator;
import me.lucko.luckperms.common.context.ImmutableContextSetImpl;
import me.lucko.luckperms.common.context.comparator.ContextComparator;
import net.luckperms.api.context.Context;
import net.luckperms.api.context.ImmutableContextSet;

public class ContextSetComparator
implements Comparator<ImmutableContextSet> {
    private static final Comparator<ImmutableContextSet> INSTANCE = new ContextSetComparator();
    private static final Comparator<ImmutableContextSet> REVERSE = INSTANCE.reversed();

    public static Comparator<ImmutableContextSet> normal() {
        return INSTANCE;
    }

    public static Comparator<ImmutableContextSet> reverse() {
        return REVERSE;
    }

    @Override
    public int compare(ImmutableContextSet o1, ImmutableContextSet o2) {
        if (o1.equals(o2)) {
            return 0;
        }
        int result = Boolean.compare(!o1.isEmpty(), !o2.isEmpty());
        if (result != 0) {
            return result;
        }
        result = Boolean.compare(o1.containsKey("server"), o2.containsKey("server"));
        if (result != 0) {
            return result;
        }
        result = Boolean.compare(o1.containsKey("world"), o2.containsKey("world"));
        if (result != 0) {
            return result;
        }
        result = Integer.compare(o1.size(), o2.size());
        if (result != 0) {
            return result;
        }
        Context[] o1Array = o1 instanceof ImmutableContextSetImpl ? ((ImmutableContextSetImpl)o1).toArray() : ContextSetComparator.toArray(o1);
        Context[] o2Array = o2 instanceof ImmutableContextSetImpl ? ((ImmutableContextSetImpl)o2).toArray() : ContextSetComparator.toArray(o2);
        for (int i = 0; i < o1Array.length; ++i) {
            Context ent1 = o1Array[i];
            Context ent2 = o2Array[i];
            result = ContextComparator.INSTANCE.compare(ent1, ent2);
            if (result == 0) continue;
            return result;
        }
        throw new AssertionError((Object)("sets are equal? " + o1 + " - " + o2));
    }

    private static Context[] toArray(ImmutableContextSet set) {
        Context[] array = set.toSet().toArray(new Context[0]);
        Arrays.sort(array, ContextComparator.INSTANCE);
        return array;
    }
}

