/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.config.generic.adapter;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import me.lucko.luckperms.common.config.generic.adapter.ConfigurationAdapter;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;

public class MultiConfigurationAdapter
implements ConfigurationAdapter {
    private final LuckPermsPlugin plugin;
    private final List<ConfigurationAdapter> adapters;

    public MultiConfigurationAdapter(LuckPermsPlugin plugin, List<ConfigurationAdapter> adapters) {
        this.plugin = plugin;
        this.adapters = ImmutableList.copyOf(adapters).reverse();
    }

    public MultiConfigurationAdapter(LuckPermsPlugin plugin, ConfigurationAdapter ... adapters) {
        this(plugin, (List<ConfigurationAdapter>)ImmutableList.copyOf((Object[])adapters));
    }

    @Override
    public LuckPermsPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public void reload() {
        for (ConfigurationAdapter adapter : this.adapters) {
            adapter.reload();
        }
    }

    @Override
    public String getString(String path, String def) {
        String result = def;
        for (ConfigurationAdapter adapter : this.adapters) {
            result = adapter.getString(path, result);
        }
        return result;
    }

    @Override
    public int getInteger(String path, int def) {
        int result = def;
        for (ConfigurationAdapter adapter : this.adapters) {
            result = adapter.getInteger(path, result);
        }
        return result;
    }

    @Override
    public boolean getBoolean(String path, boolean def) {
        boolean result = def;
        for (ConfigurationAdapter adapter : this.adapters) {
            result = adapter.getBoolean(path, result);
        }
        return result;
    }

    @Override
    public List<String> getStringList(String path, List<String> def) {
        List<String> result = def;
        for (ConfigurationAdapter adapter : this.adapters) {
            result = adapter.getStringList(path, result);
        }
        return result;
    }

    @Override
    public Map<String, String> getStringMap(String path, Map<String, String> def) {
        Map<String, String> result = def;
        for (ConfigurationAdapter adapter : this.adapters) {
            result = adapter.getStringMap(path, result);
        }
        return result;
    }
}

