/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.misc;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.bulkupdate.comparison.Comparison;
import me.lucko.luckperms.common.bulkupdate.comparison.Constraint;
import me.lucko.luckperms.common.bulkupdate.comparison.StandardComparison;
import me.lucko.luckperms.common.cache.LoadingMap;
import me.lucko.luckperms.common.command.abstraction.SingleCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.spec.CommandSpec;
import me.lucko.luckperms.common.command.tabcomplete.TabCompleter;
import me.lucko.luckperms.common.command.tabcomplete.TabCompletions;
import me.lucko.luckperms.common.command.utils.ArgumentList;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.node.comparator.NodeEntryComparator;
import me.lucko.luckperms.common.node.matcher.ConstraintNodeMatcher;
import me.lucko.luckperms.common.node.matcher.StandardNodeMatchers;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.storage.misc.NodeEntry;
import me.lucko.luckperms.common.util.Iterators;
import me.lucko.luckperms.common.util.Predicates;
import net.luckperms.api.node.Node;

public class SearchCommand
extends SingleCommand {
    public SearchCommand() {
        super(CommandSpec.SEARCH, "Search", CommandPermission.SEARCH, Predicates.notInRange(1, 3));
    }

    @Override
    public void execute(LuckPermsPlugin plugin, Sender sender, ArgumentList args, String label) {
        StandardComparison comparison = StandardComparison.parseComparison(args.get(0));
        if (comparison == null) {
            comparison = StandardComparison.EQUAL;
            args.add(0, "==");
        }
        ConstraintNodeMatcher<Node> matcher = StandardNodeMatchers.of(Constraint.of(comparison, args.get(1)));
        int page = args.getIntOrDefault(2, 1);
        Message.SEARCH_SEARCHING.send(sender, matcher.toString());
        List matchedUsers = plugin.getStorage().searchUserNodes(matcher).join();
        List matchedGroups = plugin.getStorage().searchGroupNodes(matcher).join();
        int users = matchedUsers.size();
        int groups = matchedGroups.size();
        Message.SEARCH_RESULT.send(sender, users + groups, users, groups);
        if (!matchedUsers.isEmpty()) {
            LoadingMap<UUID, String> uuidLookups = LoadingMap.of(u -> plugin.lookupUsername((UUID)u).orElseGet(u::toString));
            SearchCommand.sendResult(sender, matchedUsers, uuidLookups::get, Message.SEARCH_SHOWING_USERS, HolderType.USER, label, page, comparison);
        }
        if (!matchedGroups.isEmpty()) {
            SearchCommand.sendResult(sender, matchedGroups, Function.identity(), Message.SEARCH_SHOWING_GROUPS, HolderType.GROUP, label, page, comparison);
        }
    }

    @Override
    public List<String> tabComplete(LuckPermsPlugin plugin, Sender sender, ArgumentList args) {
        return TabCompleter.create().at(0, TabCompletions.permissions(plugin)).complete((List<String>)((Object)args));
    }

    private static <T extends Comparable<T>> void sendResult(Sender sender, List<NodeEntry<T, Node>> results, Function<T, String> lookupFunction, Message.Args3<Integer, Integer, Integer> headerMessage, HolderType holderType, String label, int page, Comparison comparison) {
        results = new ArrayList<NodeEntry<T, Node>>(results);
        results.sort(NodeEntryComparator.normal());
        int pageIndex = page - 1;
        List<List<NodeEntry<T, Node>>> pages = Iterators.divideIterable(results, 15);
        if (pageIndex < 0 || pageIndex >= pages.size()) {
            page = 1;
            pageIndex = 0;
        }
        List<NodeEntry<T, Node>> content = pages.get(pageIndex);
        List mappedContent = content.stream().map(hp -> Maps.immutableEntry((Object)((String)lookupFunction.apply(hp.getHolder())), (Object)hp)).collect(Collectors.toList());
        headerMessage.send(sender, page, pages.size(), results.size());
        for (Map.Entry ent : mappedContent) {
            Message.SEARCH_NODE_ENTRY.send(sender, comparison != StandardComparison.EQUAL, (Node)((NodeEntry)ent.getValue()).getNode(), (String)ent.getKey(), holderType, label, sender.getPlugin());
        }
    }
}

