/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.cacheddata.type;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.luckperms.api.cacheddata.Result;
import net.luckperms.api.node.types.MetaNode;
import net.luckperms.api.query.meta.MetaValueSelector;
import org.checkerframework.checker.nullness.qual.NonNull;

public class SimpleMetaValueSelector
implements MetaValueSelector {
    private final Map<String, Strategy> strategies;
    private final Strategy defaultStrategy;

    public SimpleMetaValueSelector(Map<String, Strategy> strategies, Strategy defaultStrategy) {
        this.strategies = strategies;
        this.defaultStrategy = defaultStrategy;
    }

    @Override
    public @NonNull Result<String, MetaNode> selectValue(@NonNull String key, @NonNull List<? extends Result<String, MetaNode>> values) {
        switch (values.size()) {
            case 0: {
                throw new IllegalArgumentException("values is empty");
            }
            case 1: {
                return values.get(0);
            }
        }
        return this.strategies.getOrDefault(key, this.defaultStrategy).select(values);
    }

    private static Result<String, MetaNode> selectNumber(List<? extends Result<String, MetaNode>> values, DoubleSelectionPredicate selection) {
        double current = 0.0;
        Result<String, MetaNode> selected = null;
        for (Result<String, MetaNode> result : values) {
            try {
                double parse = Double.parseDouble(result.result());
                if (selected != null && !selection.shouldSelect(parse, current)) continue;
                selected = result;
                current = parse;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return selected != null ? selected : Strategy.INHERITANCE.select(values);
    }

    @FunctionalInterface
    private static interface DoubleSelectionPredicate {
        public boolean shouldSelect(double var1, double var3);
    }

    public static enum Strategy {
        INHERITANCE{

            @Override
            public Result<String, MetaNode> select(List<? extends Result<String, MetaNode>> values) {
                return values.get(0);
            }
        }
        ,
        HIGHEST_NUMBER{
            private final DoubleSelectionPredicate selection = (value, current) -> value > current;

            @Override
            public Result<String, MetaNode> select(List<? extends Result<String, MetaNode>> values) {
                return SimpleMetaValueSelector.selectNumber(values, this.selection);
            }
        }
        ,
        LOWEST_NUMBER{
            private final DoubleSelectionPredicate selection = (value, current) -> value < current;

            @Override
            public Result<String, MetaNode> select(List<? extends Result<String, MetaNode>> values) {
                return SimpleMetaValueSelector.selectNumber(values, this.selection);
            }
        };


        public abstract Result<String, MetaNode> select(List<? extends Result<String, MetaNode>> var1);

        public static Strategy parse(String s) {
            try {
                return Strategy.valueOf(s.replace('-', '_').toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }
}

