/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.cacheddata.result;

import me.lucko.luckperms.common.calculator.processor.PermissionProcessor;
import net.luckperms.api.cacheddata.Result;
import net.luckperms.api.node.Node;
import net.luckperms.api.util.Tristate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class TristateResult
implements Result<Tristate, Node> {
    private final Tristate result;
    private final Node node;
    private final Class<? extends PermissionProcessor> processorClass;
    private TristateResult overriddenResult;
    private static final TristateResult TRUE = new TristateResult(Tristate.TRUE, null, null);
    private static final TristateResult FALSE = new TristateResult(Tristate.FALSE, null, null);
    public static final TristateResult UNDEFINED = new TristateResult(Tristate.UNDEFINED, null, null);

    private TristateResult(Tristate result, Node node, Class<? extends PermissionProcessor> processorClass) {
        this.result = result;
        this.node = node;
        this.processorClass = processorClass;
    }

    @Override
    public @NonNull Tristate result() {
        return this.result;
    }

    @Override
    public @Nullable Node node() {
        return this.node;
    }

    public @Nullable Class<? extends PermissionProcessor> processorClass() {
        return this.processorClass;
    }

    public @Nullable String processorClassFriendly() {
        if (this.processorClass == null) {
            return null;
        }
        if (this.processorClass.getName().startsWith("me.lucko.luckperms.")) {
            String simpleName = this.processorClass.getSimpleName();
            String platform = this.processorClass.getName().split("\\.")[3];
            return platform + "." + simpleName;
        }
        return this.processorClass.getName();
    }

    public @Nullable TristateResult overriddenResult() {
        return this.overriddenResult;
    }

    public void setOverriddenResult(TristateResult overriddenResult) {
        this.overriddenResult = overriddenResult;
    }

    public String toString() {
        return "TristateResult(result=" + (Object)((Object)this.result) + ", node=" + this.node + ", processorClass=" + this.processorClass + ", overriddenResult=" + this.overriddenResult + ')';
    }

    public static TristateResult forMonitoredResult(Tristate result) {
        switch (result) {
            case TRUE: {
                return TRUE;
            }
            case FALSE: {
                return FALSE;
            }
            case UNDEFINED: {
                return UNDEFINED;
            }
        }
        throw new AssertionError();
    }

    public static final class Factory {
        private final Class<? extends PermissionProcessor> processorClass;

        public Factory(Class<? extends PermissionProcessor> processorClass) {
            this.processorClass = processorClass;
        }

        public TristateResult result(Tristate result) {
            switch (result) {
                case TRUE: 
                case FALSE: {
                    return new TristateResult(result, null, this.processorClass);
                }
                case UNDEFINED: {
                    return UNDEFINED;
                }
            }
            throw new AssertionError();
        }

        public TristateResult result(@Nullable Node node) {
            if (node == null) {
                return UNDEFINED;
            }
            return new TristateResult(Tristate.of(node.getValue()), node, this.processorClass);
        }

        public TristateResult resultWithOverride(@Nullable Node node, @NonNull Tristate result) {
            if (result == Tristate.UNDEFINED) {
                return UNDEFINED;
            }
            return new TristateResult(result, node, this.processorClass);
        }
    }
}

