/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.bulkupdate.comparison;

import java.util.regex.Pattern;
import me.lucko.luckperms.common.bulkupdate.PreparedStatementBuilder;
import me.lucko.luckperms.common.bulkupdate.comparison.Comparison;

public enum StandardComparison implements Comparison
{
    EQUAL("==", "="){

        @Override
        public Comparison.CompiledExpression compile(String expression) {
            return expression::equalsIgnoreCase;
        }
    }
    ,
    NOT_EQUAL("!=", "!="){

        @Override
        public Comparison.CompiledExpression compile(String expression) {
            return string -> !expression.equalsIgnoreCase(string);
        }
    }
    ,
    SIMILAR("~~", "LIKE"){

        @Override
        public Comparison.CompiledExpression compile(String expression) {
            Pattern pattern = StandardComparison.compilePatternForLikeSyntax(expression);
            return string -> pattern.matcher(string).matches();
        }
    }
    ,
    NOT_SIMILAR("!~", "NOT LIKE"){

        @Override
        public Comparison.CompiledExpression compile(String expression) {
            Pattern pattern = StandardComparison.compilePatternForLikeSyntax(expression);
            return string -> !pattern.matcher(string).matches();
        }
    };

    public static final String WILDCARD = "%";
    public static final String WILDCARD_ONE = "_";
    private final String symbol;
    private final String asSql;

    private StandardComparison(String symbol, String asSql) {
        this.symbol = symbol;
        this.asSql = asSql;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public void appendSql(PreparedStatementBuilder builder) {
        builder.append(this.asSql);
    }

    public String toString() {
        return this.symbol;
    }

    public static StandardComparison parseComparison(String s) {
        for (StandardComparison t : StandardComparison.values()) {
            if (!t.getSymbol().equals(s)) continue;
            return t;
        }
        return null;
    }

    static Pattern compilePatternForLikeSyntax(String expression) {
        expression = expression.replace(".", "\\.");
        expression = expression.replace(WILDCARD_ONE, ".");
        expression = expression.replace(WILDCARD, ".*");
        return Pattern.compile(expression, 2);
    }
}

